/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.IDefaultImpregnable;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBoneNeedle
extends ItemGeneric
implements IDefaultImpregnable {
    private static final int IMPREGNATED_MAX_TIME = TimeHelper.tickFromMinute(30);
    private static final String IMPREGNATED_TIME_NBT_LONG = "impregnated_time";

    public ItemBoneNeedle() {
        super("bone_needle", ItemBoneNeedle.getBuilder().func_200917_a(1));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addTooltipInfo(ItemStack stack, World level, List<ITextComponent> tooltip) {
        this.addItemDesc(tooltip);
        ITextComponent impregnated = this.getTooltipDisplay(stack);
        if (impregnated == null) {
            this.addItemUse(tooltip);
        } else {
            tooltip.add(impregnated);
        }
        int impregnatedTime = this.getImpregnatedTime(level, stack);
        if (impregnatedTime > 0) {
            this.addWarn(tooltip, LangKey.MESSAGE_IMPREGNATE_DURATION, TimeHelper.getTimeStringWithUnit(impregnatedTime));
        }
        super.addTooltipInfo(stack, level, tooltip);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        ItemStack mainHandstack;
        if (player != null && hand == Hand.MAIN_HAND && (mainHandstack = player.func_184614_ca()).func_77973_b() == this && !EntityHelper.hasGlobalItemCooldown(player, this)) {
            EntityHelper.setGlobalItemCooldown(player, this, 10);
            if (!player.field_70170_p.func_201670_d()) {
                if (this.impregnate(mainHandstack, target)) {
                    NBTStackHelper.setLong(stack, IMPREGNATED_TIME_NBT_LONG, TimeHelper.worldTicks(player.field_70170_p) + (long)IMPREGNATED_MAX_TIME);
                    LangKey.MESSAGE_IMPREGNATE_NEEDLE_SUCCESS.sendMessage(player, StyleType.MESSAGE_SPECIAL, new Object[]{target.func_200200_C_()});
                    ModTriggers.IMPREGNATED_BONE_NEEDLE.trigger((ServerPlayerEntity)player);
                } else {
                    LangKey.MESSAGE_IMPREGNATE_NEEDLE_FAILED.sendMessage(player, StyleType.MESSAGE_SPECIAL, new Object[0]);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (!world.func_201670_d() && stack.func_77973_b() == this && EntityHelper.isValidPlayer(entity) && !this.getEntityType(stack).isEmpty() && this.getImpregnatedTime(world, stack) == 1) {
            NBTStackHelper.removeKeyName(stack, IMPREGNATED_TIME_NBT_LONG);
            NBTStackHelper.removeKeyName(stack, "entity_type");
        }
    }

    private int getImpregnatedTime(@Nullable World level, ItemStack stack) {
        return level != null && stack.func_77973_b() == this ? NBTStackHelper.getTimer(TimeHelper.worldTicks(level), stack, IMPREGNATED_TIME_NBT_LONG, IMPREGNATED_MAX_TIME) : 0;
    }
}

