/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModSounds;

public abstract class ItemCastableMagic
extends ItemGeneric {
    protected static final Map<UUID, Long> USING = new ConcurrentHashMap<UUID, Long>();
    protected static final Map<UUID, LivingEntity> TARGET = new ConcurrentHashMap<UUID, LivingEntity>();
    protected static final String COOLDOWN_TIME_NBT_LONG = "cooldown_time";

    protected ItemCastableMagic(String name, Item.Properties builder, BooleanSupplier supplierEnabled) {
        super(name, builder, supplierEnabled);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return super.func_200295_i(stack).func_230531_f_().func_230530_a_(StyleType.MESSAGE_SPECIAL);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        return EntityHelper.isValidPlayer(context.func_195999_j()) && this.getCastingTarget(stack) != CastingTarget.TARGET_ONLY ? (this.canBlockInteractFirst(context.func_195991_k(), context.func_195995_a(), stack) ? ActionResultType.PASS : this.func_77659_a(context.func_195991_k(), context.func_195999_j(), context.func_221531_n()).func_188397_a()) : ActionResultType.FAIL;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        CastingTarget castingTarget = this.getCastingTarget(stack);
        if (castingTarget == CastingTarget.TARGET_OR_SELF || castingTarget == CastingTarget.TARGET_ONLY) {
            if (this.isTargetForCasting(player, target)) {
                if (this.canAffectTarget(stack, target)) {
                    UUID uuid = player.func_146103_bH().getId();
                    TARGET.put(uuid, target);
                    ActionResultType result = this.func_77659_a(player.field_70170_p, player, hand).func_188397_a();
                    if (result.func_226247_b_()) {
                        return ActionResultType.SUCCESS;
                    }
                    TARGET.remove(uuid);
                    return result;
                }
                if (!player.field_70170_p.func_201670_d()) {
                    LangKey.MESSAGE_CANT_APPLY_EFFECT.sendMessage(player, target.func_200200_C_());
                }
                EntityHelper.setGlobalItemCooldown(player, this, 10);
                return ActionResultType.SUCCESS;
            }
            if (castingTarget == CastingTarget.TARGET_ONLY) {
                return ActionResultType.SUCCESS;
            }
        }
        return this.func_77659_a(player.field_70170_p, player, hand).func_188397_a();
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (this.getCastingTarget(heldStack) == CastingTarget.TARGET_ONLY && TARGET.get(player.func_146103_bH().getId()) == null || !EntityHelper.isValidPlayer(player)) {
            return ActionResult.func_226251_d_((Object)heldStack);
        }
        if (heldStack.func_77973_b() != this) {
            return ActionResult.func_226250_c_((Object)heldStack);
        }
        if (EntityHelper.hasGlobalItemCooldown(player, this)) {
            return ActionResult.func_226249_b_((Object)heldStack);
        }
        player.func_184598_c(hand);
        return ActionResult.func_226248_a_((Object)heldStack);
    }

    public void func_77615_a(ItemStack stack, World level, LivingEntity entity, int timeLeft) {
        super.func_77615_a(stack, level, entity, timeLeft);
        this.resetCasting((PlayerEntity)entity);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        if (EntityHelper.isValidPlayer((Entity)entity)) {
            ServerPlayerEntity player;
            if (stack.func_77973_b() == this && EntityHelper.noGlobalItemCooldown((PlayerEntity)entity, this) && !entity.field_70170_p.func_201670_d() && this.doEffects((player = (ServerPlayerEntity)entity).func_71121_q(), player, stack, TARGET.get(player.func_146103_bH().getId()))) {
                ModSounds.playSoundAllAround(ModSounds.MAGIC_USE01, SoundCategory.PLAYERS, (World)player.func_71121_q(), player.func_233580_cy_(), 0.5f, 0.5f);
                if (!player.field_71075_bZ.field_75098_d && this.canConsumeOnUse()) {
                    stack = this.onConsumeItem((PlayerEntity)player, stack);
                }
            }
            EntityHelper.setGlobalItemCooldown((PlayerEntity)entity, this, 10);
            this.resetCasting((PlayerEntity)entity);
        }
        return stack;
    }

    protected ItemStack onConsumeItem(PlayerEntity player, ItemStack stack) {
        if (stack.func_190916_E() > 1) {
            stack.func_190918_g(1);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int timeLeft) {
        boolean isStarting;
        if (stack.func_77973_b() != this || !EntityHelper.isValidPlayer((Entity)entity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        boolean bl = isStarting = timeLeft == this.func_77626_a(stack);
        if (isStarting) {
            int concentrationLevel = player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(cap -> cap.getPerkLevelWithBonus(player, ModPerks.concentration)).orElse(0);
            USING.put(player.func_146103_bH().getId(), TimeHelper.systemTime() + (long)((float)TimeUnit.SECONDS.toMillis(1L) * ((float)this.func_77626_a(stack) / 20.0f * (concentrationLevel == 1 ? 0.8f : (concentrationLevel > 1 ? 0.5f : 1.0f)))));
            if (player.field_70170_p.func_201670_d()) {
                this.produceParticleCasting(stack, player);
            } else {
                ModSounds.playSoundAllAround(SoundEvents.field_191244_bn, SoundCategory.PLAYERS, player.field_70170_p, player.func_233580_cy_(), 0.5f, 0.5f);
            }
        } else if (!player.field_70170_p.func_201670_d() && USING.containsKey(player.func_146103_bH().getId()) && USING.get(player.func_146103_bH().getId()) < TimeHelper.systemTime() && player.func_184587_cr() && player.func_184607_cu().func_77973_b() == this) {
            ItemStack resultStack = ForgeEventFactory.onItemUseFinish((LivingEntity)player, (ItemStack)player.func_184607_cu().func_77946_l(), (int)0, (ItemStack)player.func_184607_cu().func_77950_b(player.field_70170_p, (LivingEntity)player));
            if (resultStack != player.func_184607_cu()) {
                player.func_184611_a(player.func_184600_cs(), resultStack);
            }
            player.func_184602_cy();
        }
    }

    protected void produceParticleCasting(ItemStack stack, PlayerEntity player) {
        ModTombstone.PROXY.produceParticleCasting(CastingType.SCROLL, Optional.ofNullable(TARGET.get(player.func_146103_bH().getId())).orElse((LivingEntity)player), p -> !player.func_184587_cr() || player.func_184612_cw() == 1);
    }

    public int func_77626_a(ItemStack stack) {
        return 80;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    protected abstract boolean doEffects(ServerWorld var1, ServerPlayerEntity var2, ItemStack var3, @Nullable LivingEntity var4);

    protected boolean canBlockInteractFirst(World world, BlockPos pos, ItemStack stack) {
        return false;
    }

    protected boolean isTargetForCasting(PlayerEntity player, @Nullable LivingEntity target) {
        return false;
    }

    protected boolean canAffectTarget(ItemStack stack, LivingEntity target) {
        return true;
    }

    protected boolean canConsumeOnUse() {
        return true;
    }

    protected CastingTarget getCastingTarget(ItemStack stack) {
        return CastingTarget.SELF;
    }

    private void resetCasting(PlayerEntity player) {
        UUID uuid = player.func_146103_bH().getId();
        USING.remove(uuid);
        TARGET.remove(uuid);
    }

    protected static Item.Properties getBuilder() {
        return ItemGeneric.getBuilder().func_200917_a(1).func_234689_a_();
    }

    static enum CastingTarget {
        SELF,
        AREA,
        TARGET_ONLY,
        TARGET_OR_SELF;

    }
}

