/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.capability.SoulConsumerProvider;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModItems;

public class ItemChristmasGift
extends ItemGeneric
implements ISoulConsumer {
    public ItemChristmasGift() {
        super("christmas_gift", ItemChristmasGift.getBuilder().func_200917_a(1).func_234689_a_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addTooltipInfo(ItemStack stack, World level, List<ITextComponent> tooltip) {
        this.addItemDesc(tooltip);
        if (LocalDate.now().get(ChronoField.DAY_OF_MONTH) >= 25) {
            this.addItemUse(tooltip);
        }
        super.addTooltipInfo(stack, level, tooltip);
    }

    @Override
    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (stack.func_77973_b() == this && !TimeHelper.isDateAroundChristmas()) {
            stack.func_190918_g(stack.func_190916_E());
        }
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return false;
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(World level, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrength) {
        if (TimeHelper.isDateAroundChristmas() && LocalDate.now().get(ChronoField.DAY_OF_MONTH) >= 25) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)ModItems.essence_of_undeath));
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)ModItems.merchant_stone));
            player.func_195068_e(1000);
            player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(player, 10, 0));
            stack.func_190918_g(1);
            return ISoulConsumer.ConsumeResult.success((ITextComponent)LangKey.MESSAGE_GIFT_SUCCESS.getText(new Object[0]), 1);
        }
        return ISoulConsumer.ConsumeResult.fail((ITextComponent)LangKey.MESSAGE_GIFT_FAILED.getText(new Object[0]));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new SoulConsumerProvider(this);
    }
}

