/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityPlayerGrave;

public class ItemGraveKey
extends ItemGraveMagic {
    private static final String OWNER_ID_NBT_UUID = "owner_id";
    private static final String TOMB_POS_NBT_LOCATION = "tombPos";

    public ItemGraveKey() {
        super("grave_key", () -> SharedConfigTombstone.allowed_magic_items.allowGraveKey.get());
        this.withSoulboundInfo();
    }

    @Override
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addTooltipInfo(ItemStack stack, World level, List<ITextComponent> tooltip) {
        String id = this.isEnchanted(stack) ? "2" : "1";
        this.addItemDesc(tooltip, id, new Object[0]);
        this.addItemDesc(tooltip, "3", new Object[0]);
        this.addItemPosition(tooltip, this.getTombPos(stack));
        this.addItemUse(tooltip, id, new Object[0]);
        super.addTooltipInfo(stack, level, tooltip);
    }

    public ItemStack createWithInfo(PlayerEntity player, Location location) {
        ItemStack stack = new ItemStack((IItemProvider)this);
        if (!location.isOrigin()) {
            CompoundNBT tag = stack.func_196082_o();
            NBTStackHelper.setUUID(tag, OWNER_ID_NBT_UUID, player.func_146103_bH().getId());
            NBTStackHelper.setLocation(tag, TOMB_POS_NBT_LOCATION, location);
        }
        return stack;
    }

    public Optional<UUID> getOwnerId(ItemStack stack) {
        return stack.func_77973_b() == this ? NBTStackHelper.getUUID(stack, OWNER_ID_NBT_UUID) : Optional.empty();
    }

    public Location getTombPos(ItemStack stack) {
        if (stack.func_77973_b() == this) {
            return NBTStackHelper.getLocation(stack, TOMB_POS_NBT_LOCATION);
        }
        return Location.ORIGIN;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (!world.func_201670_d() && EntityHelper.isValidPlayer(entity) && entity.func_70089_S() && stack.func_77973_b() == this) {
            double range;
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            Location location = this.getTombPos(stack);
            boolean isBadKey = location.isOrigin();
            if (!isBadKey && location.isSameDimension(world) && (range = player.func_70092_e((double)location.getPos().func_177958_n(), (double)location.getPos().func_177956_o(), (double)location.getPos().func_177952_p())) < 43000.0 && Helper.RANDOM.nextInt(range >= 100.0 ? 2400 : (isSelected ? 100 : 300)) == 0 && world.func_195588_v(location.getPos())) {
                Optional<TileEntityPlayerGrave> res = Optional.ofNullable(world.func_175625_s(location.getPos())).filter(TileEntityPlayerGrave.class::isInstance).map(TileEntityPlayerGrave.class::cast);
                boolean bl = isBadKey = !res.isPresent() || this.getOwnerId(stack).map(id -> !id.equals(((TileEntityPlayerGrave)((Object)((Object)res.get()))).getOwnerId())).orElse(false) != false;
            }
            if (isBadKey) {
                stack.func_190918_g(1);
                player.field_71069_bz.func_75142_b();
            }
        }
    }

    public boolean removeKeyForGraveInInventory(PlayerEntity player, TileEntityPlayerGrave grave) {
        assert (grave.func_145831_w() != null);
        return InventoryHelper.removeFirstInInventory(player, stack -> stack.func_77973_b() == this && this.getTombPos((ItemStack)stack).equals(new Location(grave.func_174877_v(), grave.func_145831_w())) && this.getOwnerId((ItemStack)stack).map(id -> id.equals(grave.getOwnerId())).orElse(false) != false);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrenght) {
        if (stack.func_77973_b() == this) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return ISoulConsumer.ConsumeResult.success(1);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    protected boolean doEffects(ServerWorld world, ServerPlayerEntity player, ItemStack stack, @Nullable LivingEntity target) {
        Location location = this.getTombPos(stack);
        if (location.isOrigin()) {
            LangKey.MESSAGE_INVALID_LOCATION.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        if (!location.isSameDimension((World)world) && !((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue()) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        assert (player.func_184102_h() != null);
        ServerWorld targetWorld = player.func_184102_h().func_71218_a(location.dim);
        if (!Helper.isValidPos((World)targetWorld, location.getPos())) {
            LangKey.MESSAGE_INVALID_LOCATION.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        NBTStackHelper.setBoolean(stack, "enchant", false);
        CallbackHandler.addFastCallback(() -> {
            PlayerEntity newPlayer = (PlayerEntity)Helper.teleportToGrave(player, location, targetWorld);
            if (((Boolean)ConfigTombstone.player_death.nerfGhostlyShapeTeleportWithKey.get()).booleanValue()) {
                EffectHelper.capDuration((LivingEntity)newPlayer, ModEffects.ghostly_shape, 200);
            }
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage(newPlayer, new Object[0]);
            ModTriggers.TELEPORT_TO_GRAVE.trigger(player);
        });
        return true;
    }

    @Override
    protected boolean canConsumeOnUse() {
        return false;
    }

    @Override
    protected int getCastingCooldown() {
        return 0;
    }

    @Override
    protected int getUseMax() {
        return 1;
    }

    public void reenchantOnDeath(PlayerEntity player, ItemStack key) {
        int chanceEnchantedKey;
        if (key.func_77973_b() == this && (chanceEnchantedKey = ((Integer)SharedConfigTombstone.general.chanceEnchantedGraveKey.get()).intValue()) >= 0 && ((chanceEnchantedKey += EntityHelper.getPerkLevelWithBonus(player, ModPerks.jailer) * 20) >= 100 || chanceEnchantedKey > 0 && Helper.getRandom(1, 100) <= chanceEnchantedKey)) {
            NBTStackHelper.setBoolean(key, "enchant", true);
        }
    }

    @Override
    protected boolean canBlockInteractFirst(World world, BlockPos pos, ItemStack stack) {
        return super.canBlockInteractFirst(world, pos, stack) || ModBlocks.isPlayerGrave(world.func_180495_p(pos).func_177230_c());
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            CompoundNBT tag = stack.func_77978_p().func_74737_b();
            tag.func_82580_o(OWNER_ID_NBT_UUID);
            return tag;
        }
        return null;
    }
}

