/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.capability.SoulConsumerProvider;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.item.ItemCastableMagic;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModSounds;

public abstract class ItemGraveMagic
extends ItemCastableMagic
implements ISoulConsumer {
    protected static final String ANCIENT_NBT_BOOL = "ancient";
    protected static final String USE_COUNT_NBT_INT = "useCount";
    protected static final String COOLDOWN_TIME_NBT_LONG = "cooldown_time";

    protected ItemGraveMagic(String name, BooleanSupplier supplierBoolean) {
        super(name, ItemGraveMagic.getBuilder(), supplierBoolean);
    }

    protected ItemGraveMagic(String name, Item.Properties builder, BooleanSupplier supplierEnabled) {
        super(name, builder, supplierEnabled);
    }

    @Override
    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent name = super.func_200295_i(stack);
        return this.isAncient(stack) ? LangKey.MESSAGE_ANCIENT_ITEM.getText(name).func_230530_a_(StyleType.MESSAGE_SPECIAL) : (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getText(name).func_230530_a_(StyleType.MESSAGE_SPECIAL) : name);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addTooltipInfo(ItemStack stack, World level, List<ITextComponent> tooltip) {
        if (this.isEnchanted(stack)) {
            int cd;
            int uses;
            if (this.canConsumeOnUse() && (uses = this.getUseCount(stack)) > 0) {
                this.addInfo(tooltip, LangKey.MESSAGE_USE_LEFT, uses);
            }
            if ((cd = this.getCooldown(level, stack)) > 10) {
                this.addWarn(tooltip, LangKey.MESSAGE_IN_COOLDOWN, TimeHelper.getTimeStringWithUnit(cd));
            }
        }
        super.addTooltipInfo(stack, level, tooltip);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        int cd = this.getCooldown(world, heldStack);
        if (cd > 0) {
            if (!world.func_201670_d()) {
                EntityHelper.setGlobalItemCooldown(player, this, 20);
                LangKey.MESSAGE_IN_COOLDOWN.sendMessage(player, TimeHelper.getTimeStringWithUnit(cd));
            }
            return ActionResult.func_226251_d_((Object)heldStack);
        }
        return this.isEnchanted(heldStack) ? super.func_77659_a(world, player, hand) : ActionResult.func_226250_c_((Object)heldStack);
    }

    @Override
    public void onUsingTick(ItemStack stack, LivingEntity entity, int timeLeft) {
        if (this.isEnchanted(stack)) {
            super.onUsingTick(stack, entity, timeLeft);
        }
    }

    @Override
    protected void produceParticleCasting(ItemStack stack, PlayerEntity player) {
        ModTombstone.PROXY.produceParticleCasting(this.getCastingType(stack), (LivingEntity)Optional.ofNullable(TARGET.get(player.func_146103_bH().getId())).orElse(player), p -> !player.func_184587_cr() || player.func_184612_cw() == 1);
    }

    protected CastingType getCastingType(ItemStack stack) {
        return CastingType.SIMPLE_TELEPORT;
    }

    @Override
    protected boolean doEffects(ServerWorld level, ServerPlayerEntity player, ItemStack stack, @Nullable LivingEntity target) {
        if (this.isEnchanted(stack)) {
            int cd;
            ModSounds.playSoundAllAround(ModSounds.MAGIC_USE01, SoundCategory.PLAYERS, (World)level, player.func_233580_cy_(), 0.5f, 0.5f);
            if (!stack.func_190926_b() && (cd = this.getCastingCooldown()) > 0) {
                this.setCooldown((World)level, stack, cd);
            }
        }
        return false;
    }

    @Override
    protected ItemStack onConsumeItem(PlayerEntity player, ItemStack stack) {
        int useCount = this.getUseCount(stack);
        if (useCount < 2) {
            stack.func_190918_g(1);
            return stack;
        }
        this.setUseCount(stack, --useCount);
        return stack;
    }

    protected int getCastingCooldown() {
        return 0;
    }

    public boolean isCooldown(World world, ItemStack stack) {
        return this.getCooldown(world, stack) > 0;
    }

    public int getCooldown(@Nullable World level, ItemStack stack) {
        return level != null && stack.func_77973_b() == this ? NBTStackHelper.getTimer(TimeHelper.worldTicks(level), stack, COOLDOWN_TIME_NBT_LONG, this.getCastingCooldown()) : 0;
    }

    public void setCooldown(@Nullable World world, ItemStack stack, int time) {
        if (world != null && stack.func_77973_b() == this) {
            NBTStackHelper.setLong(stack, COOLDOWN_TIME_NBT_LONG, TimeHelper.worldTicks(world) + (long)time);
        }
    }

    @Override
    protected boolean canBlockInteractFirst(World world, BlockPos pos, ItemStack stack) {
        return !this.isEnchanted(stack) || ModBlocks.isDecorativeGrave(world.func_180495_p(pos).func_177230_c());
    }

    @Override
    public boolean canEnchant(World world, BlockPos gravePos, PlayerEntity player, ItemStack stack) {
        return this.isEnabled();
    }

    protected abstract int getUseMax();

    public int getUseCount(ItemStack stack) {
        if (stack.func_77973_b() != this) {
            return 0;
        }
        if (this.getUseMax() == 1 || !this.canConsumeOnUse()) {
            return 1;
        }
        return Math.min(NBTStackHelper.getInteger(stack, USE_COUNT_NBT_INT, 0), this.getUseMax());
    }

    protected ItemStack setUseCount(ItemStack stack, int useCount) {
        if (this.canConsumeOnUse()) {
            NBTStackHelper.setInteger(stack, USE_COUNT_NBT_INT, Math.min(useCount, this.getUseMax()));
        }
        return stack;
    }

    public boolean isAncient(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, ANCIENT_NBT_BOOL);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new SoulConsumerProvider(this);
    }
}

