/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityDecorativeGrave;

public class ItemGravePlate
extends ItemGeneric {
    public ItemGravePlate() {
        super("grave_plate", ItemGravePlate.getBuilder().func_200917_a(1).func_234689_a_());
    }

    public ITextComponent getHighlightTip(ItemStack stack, ITextComponent displayName) {
        displayName = super.func_200295_i(stack);
        return EngravableHelper.isEngraved(stack) ? LangKey.MESSAGE_ENGRAVED_ITEM.getText(displayName) : displayName;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World level, List<ITextComponent> tooltip, ITooltipFlag flag) {
        ITextComponent displayName = super.func_200295_i(stack);
        if (EngravableHelper.isEngraved(stack)) {
            displayName = LangKey.MESSAGE_ENGRAVED_ITEM.getText(displayName);
        }
        if (tooltip.size() > 0) {
            tooltip.set(0, displayName);
        } else {
            tooltip.add(displayName);
        }
        super.func_77624_a(stack, level, tooltip, flag);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addTooltipInfo(ItemStack stack, World level, List<ITextComponent> tooltip) {
        String engravedName = EngravableHelper.getEngravedName(stack);
        if (engravedName.isEmpty()) {
            tooltip.add((ITextComponent)LangKey.MESSAGE_ENGRAVABLE.getText(StyleType.TOOLTIP_DESC, new Object[]{new StringTextComponent("[").func_230529_a_(Items.field_151042_j.func_200296_o()).func_240702_b_("]").func_240703_c_(StyleType.TOOLTIP_ITEM)}));
        } else {
            tooltip.add((ITextComponent)LangKey.MESSAGE_ENGRAVED.getText(StyleType.TOOLTIP_DESC, new Object[]{new StringTextComponent('\"' + engravedName + '\"').func_230530_a_(StyleType.TOOLTIP_ITEM)}));
        }
        super.addTooltipInfo(stack, level, tooltip);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        BlockState state;
        if (EntityHelper.isValidPlayer(context.func_195999_j()) && ModBlocks.isDecorativeGrave((state = context.func_195991_k().func_180495_p(context.func_195995_a())).func_177230_c())) {
            EntityHelper.setGlobalItemCooldown(context.func_195999_j(), this, 100);
            String engravedName = EngravableHelper.getEngravedName(stack);
            if (!engravedName.isEmpty()) {
                TileEntityDecorativeGrave tile;
                if (!context.func_195991_k().func_201670_d() && (tile = (TileEntityDecorativeGrave)((Object)((BlockDecorativeGrave)state.func_177230_c()).getTileEntity(context.func_195991_k(), context.func_195995_a()))) != null) {
                    String ownerName = tile.getOwnerName();
                    boolean wasEngraved = (Boolean)state.func_177229_b((Property)BlockGraveBase.IS_ENGRAVED);
                    BlockState newState = (BlockState)state.func_206870_a((Property)BlockGraveBase.IS_ENGRAVED, (Comparable)Boolean.valueOf(true));
                    if (!wasEngraved) {
                        context.func_195991_k().func_180501_a(context.func_195995_a(), newState, 3);
                    } else if (!((Boolean)ConfigTombstone.decorative_grave.canReplaceGravePlate.get()).booleanValue()) {
                        LangKey.MESSAGE_GRAVE_PLATE_REPLACEMENT_NOT_ALLOWED.sendMessage(context.func_195999_j(), StyleType.COLOR_OFF, new Object[0]);
                        return ActionResultType.FAIL;
                    }
                    tile.setOwner(context.func_195999_j().func_146103_bH().getId(), engravedName, TimeHelper.systemTime());
                    tile.func_70296_d();
                    context.func_195991_k().func_184138_a(context.func_195995_a(), state, newState, 3);
                    if (ownerName.isEmpty()) {
                        stack.func_190918_g(1);
                    } else {
                        EngravableHelper.setEngravedName(stack, ownerName);
                    }
                    ModTriggers.ENGRAVE_DECORATIVE_GRAVE.trigger((ServerPlayerEntity)context.func_195999_j());
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new StringTextComponent(EngravableHelper.getEngravedName(stack));
    }

    @Override
    public String func_77658_a() {
        return "tombstone.item." + this.name;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    @Override
    public String getSimpleName() {
        return this.name;
    }
}

