/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemLollipop
extends ItemGeneric
implements IDelayedNBTLoot {
    public ItemLollipop() {
        super("lollipop", ItemLollipop.getBuilder().func_221540_a(new Food.Builder().func_221456_a(2).func_221454_a(2.0f).func_221457_c().func_221455_b().func_221453_d()));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addTooltipInfo(ItemStack stack, World level, List<ITextComponent> tooltip) {
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77667_c(stack) + ".desc").func_230530_a_(StyleType.TOOLTIP_DESC));
        super.addTooltipInfo(stack, level, tooltip);
    }

    @Override
    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab) && this.isEnabled()) {
            Arrays.stream(ModelColor.values()).forEach(modelColor -> items.add((Object)this.setColor(new ItemStack((IItemProvider)this), (ModelColor)((Object)modelColor))));
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return super.func_200295_i(stack).func_230531_f_().func_230530_a_(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    public String getSimpleName() {
        return this.name;
    }

    public int getColor(ItemStack stack, int tintIndex) {
        if (stack.func_77973_b() == this && tintIndex == 0) {
            short ordinal = NBTStackHelper.getShort(stack, "model_color", (short)-1);
            return 0xFF000000 | (ordinal >= 0 && ordinal < ModelColor.values().length ? ModelColor.values()[ordinal] : ModelColor.RED).color;
        }
        return -1;
    }

    public ItemStack setColor(ItemStack stack, ModelColor modelColor) {
        if (stack.func_77973_b() == this) {
            NBTStackHelper.setShort(stack, "model_color", (short)modelColor.ordinal());
        }
        return stack;
    }

    public ItemStack getRandomItemStack() {
        return this.getRandomItemStack(1);
    }

    public ItemStack getRandomItemStack(int count) {
        return this.resetColor(new ItemStack((IItemProvider)this, count));
    }

    public ItemStack resetColor(ItemStack stack) {
        return this.setColor(stack, ModelColor.getRandom());
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        super.func_77654_b(stack, world, entity);
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            EffectHelper.addRandomEffect((PlayerEntity)player, 6000, true, false, false);
            ModTriggers.EAT_LOLLIPOP.trigger(player);
        }
        return stack;
    }

    @Override
    public String func_77658_a() {
        return "tombstone.item." + this.name;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.EAT;
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, CompoundNBT tag, LootContext context) {
        return this.resetColor(stack);
    }

    public static enum ModelColor {
        YELLOW(14469140),
        PURPLE(5584316),
        GREEN(4174479),
        MAGENTA(11154876),
        RED(12334416),
        ORANGE(16756224);

        private final int color;

        private ModelColor(int color) {
            this.color = color;
        }

        public static ModelColor getRandom() {
            return ModelColor.values()[Helper.RANDOM.nextInt(ModelColor.values().length)];
        }
    }
}

