/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemScroll;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemScrollBuff
extends ItemScroll {
    private final SpellBuff spellBuff;

    public ItemScrollBuff(SpellBuff spellBuff) {
        super("scroll_of_" + spellBuff.getName(), ItemScrollBuff.getBuilder().func_200917_a(64), spellBuff::isEnabled);
        this.spellBuff = spellBuff;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addTooltipInfo(ItemStack stack, World level, List<ITextComponent> tooltip) {
        this.addEffectInfo(tooltip, (Effect)this.spellBuff.potionSupplier.get());
        if (this.isEnchanted(stack)) {
            tooltip.add((ITextComponent)(this.isAncient(stack) ? LangKey.MESSAGE_AREA_BUFF : LangKey.MESSAGE_USEABLE_ON_ALLY).getText(new Object[0]).func_240703_c_(StyleType.EFFECT_DESCRIPTION));
            this.addItemUse(tooltip, LangKey.ITEM_SCROLL_BUFF_USE2, new Object[0]);
        } else {
            this.addItemUse(tooltip, LangKey.ITEM_SCROLL_BUFF_USE1, new Object[0]);
        }
        tooltip.add((ITextComponent)new StringTextComponent("(" + StringUtils.func_76337_a((int)MathHelper.func_76141_d((float)((float)((Integer)SharedConfigTombstone.magic_item.scrollDuration.get()).intValue() * (1.0f + (float)EntityHelper.getPerkLevelWithBonus(ModTombstone.PROXY.getClientPlayer(), ModPerks.alchemist) / 10.0f)))) + ")").func_230530_a_(StyleType.MESSAGE_SPELL));
        super.addTooltipInfo(stack, level, tooltip);
    }

    @Override
    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab) && this.isEnabled()) {
            ItemStack enchantedStack = NBTStackHelper.setBoolean(new ItemStack((IItemProvider)this), "enchant", true);
            items.add((Object)enchantedStack);
            items.add((Object)NBTStackHelper.setBoolean(enchantedStack.func_77946_l(), "ancient", true));
        }
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrength) {
        if (stack.func_77973_b() == this) {
            int consume;
            ItemStack enchantedStack = stack.func_77946_l();
            enchantedStack.func_190920_e(1);
            NBTStackHelper.setBoolean(enchantedStack, "enchant", true);
            int n = consume = !this.isAncient(enchantedStack) && soulStrength > 1 ? 2 : 1;
            if (consume == 2) {
                NBTStackHelper.setBoolean(enchantedStack, "ancient", true);
            }
            stack.func_190918_g(1);
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)enchantedStack);
            return ISoulConsumer.ConsumeResult.success(consume);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    protected boolean doEffects(ServerWorld world, ServerPlayerEntity player, ItemStack stack, @Nullable LivingEntity target) {
        EffectInstance effectInstance = new EffectInstance((Effect)this.spellBuff.potionSupplier.get(), MathHelper.func_76141_d((float)((float)((Integer)SharedConfigTombstone.magic_item.scrollDuration.get()).intValue() * (1.0f + (float)EntityHelper.getPerkLevelWithBonus((PlayerEntity)player, ModPerks.alchemist) / 10.0f))), this.spellBuff.amplifier);
        IFormattableTextComponent effectName = effectInstance.func_188419_a().func_199286_c().func_230531_f_().func_230530_a_(StyleType.MESSAGE_SPECIAL);
        if (this.isAncient(stack)) {
            List<LivingEntity> allies = world.func_175674_a((Entity)player, player.func_174813_aQ().func_72314_b(3.0, 0.0, 3.0), e -> e != null && e.func_70089_S()).stream().filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).filter(e -> this.isTargetForCasting((PlayerEntity)player, (LivingEntity)e)).collect(Collectors.toList());
            allies.forEach(arg_0 -> ItemScrollBuff.lambda$doEffects$2(effectInstance, (ITextComponent)effectName, arg_0));
            ModTriggers.CAST_ON_ALLY.trigger(player, allies.size());
            EffectHelper.addEffect((LivingEntity)player, new EffectInstance(effectInstance));
            LangKey.MESSAGE_SPELL_CAST_AROUND.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPELL, new Object[]{effectName});
        } else {
            if (target == null) {
                target = player;
            } else {
                ModTriggers.CAST_ON_ALLY.trigger(player);
            }
            EffectHelper.addEffect(target, new EffectInstance(effectInstance));
            if (EntityHelper.isValidServerPlayer((Entity)target)) {
                LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage((PlayerEntity)((ServerPlayerEntity)target), StyleType.MESSAGE_SPELL, new Object[]{effectName});
            }
            if (!target.equals((Object)player)) {
                LangKey.MESSAGE_SPELL_CAST_ON_TARGET.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPELL, new Object[]{effectName, target.func_200200_C_().func_230531_f_().func_230530_a_(StyleType.TOOLTIP_ITEM)});
            }
        }
        ModTriggers.SPELL_BUFF.get((Object)this.spellBuff).trigger(player);
        return true;
    }

    @Override
    protected boolean canAffectTarget(ItemStack stack, LivingEntity target) {
        return !this.isAncient(stack) && target.func_70687_e(new EffectInstance((Effect)this.spellBuff.potionSupplier.get()));
    }

    private static /* synthetic */ void lambda$doEffects$2(EffectInstance effectInstance, ITextComponent effectName, LivingEntity e) {
        EffectHelper.addEffect(e, new EffectInstance(effectInstance));
        if (EntityHelper.isValidServerPlayer((Entity)e)) {
            LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage((PlayerEntity)((ServerPlayerEntity)e), StyleType.MESSAGE_SPELL, new Object[]{effectName});
        }
    }

    public static enum SpellBuff {
        PRESERVATION(() -> ModEffects.preservation, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfPreservation.get()),
        UNSTABLE_INTANGIBILITY(() -> ModEffects.unstable_intangibility, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfUnstableIntangibility.get()),
        FEATHER_FALL(() -> ModEffects.feather_fall, 2, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfFeatherFall.get()),
        PURIFICATION(() -> ModEffects.purification, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfPurification.get()),
        TRUE_SIGHT(() -> ModEffects.true_sight, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfTrueSight.get()),
        REACH(() -> ModEffects.reach, 4, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfReach.get()),
        LIGHTNING_RESISTANCE(() -> ModEffects.lightning_resistance, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfLightningResistance.get()),
        FROST_RESISTANCE(() -> ModEffects.frost_resistance, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfFrostResistance.get()),
        AQUATIC_LIFE(() -> ModEffects.aquatic_life, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfAquaticLife.get()),
        MERCY(() -> ModEffects.mercy, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfMercy.get());

        private final Supplier<Effect> potionSupplier;
        private final int amplifier;
        private final BooleanSupplier supplierEnabled;

        private SpellBuff(Supplier<Effect> potionSupplier, int amplifier, BooleanSupplier supplierEnabled) {
            this.potionSupplier = potionSupplier;
            this.amplifier = amplifier;
            this.supplierEnabled = supplierEnabled;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.US);
        }

        public boolean isEnabled() {
            return this.supplierEnabled.getAsBoolean();
        }

        public Item getItem() {
            return ModItems.scroll_buff.get((Object)this);
        }

        public static Optional<ItemStack> getRandomEnchantedScroll(boolean isAncient) {
            return Helper.getRandomInList(Arrays.stream(SpellBuff.values()).filter(SpellBuff::isEnabled).collect(Collectors.toList())).map(buff -> {
                ItemStack stack = NBTStackHelper.setBoolean(new ItemStack((IItemProvider)buff.getItem()), "enchant", true);
                if (isAncient) {
                    NBTStackHelper.setBoolean(stack, "ancient", true);
                }
                return stack;
            });
        }
    }
}

