/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemScroll;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemScrollOfKnowledge
extends ItemScroll
implements IDelayedNBTLoot {
    public ItemScrollOfKnowledge() {
        super("scroll_of_knowledge", () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfKnowledge.get());
    }

    @Override
    public ITextComponent func_200295_i(ItemStack stack) {
        return Optional.ofNullable(stack.func_77978_p()).filter(t -> t.func_74767_n("is_loot")).map(t -> new TranslationTextComponent(this.func_77667_c(stack) + ".loot").func_230530_a_(StyleType.MESSAGE_SPECIAL)).orElse(super.func_200295_i(stack));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addTooltipInfo(ItemStack stack, World level, List<ITextComponent> tooltip) {
        if (!this.isEnchanted(stack)) {
            this.addItemDesc(tooltip, "1", SharedConfigTombstone.magic_item.scrollOfKnowledgeLoss.get());
            this.addItemUse(tooltip, "1", new Object[0]);
        } else {
            this.addItemDesc(tooltip, "2", new Object[0]);
            this.addInfo(tooltip, LangKey.MESSAGE_STORED_EXPERIENCE, this.getStoredXp(stack));
            this.addItemUse(tooltip, "2", new Object[0]);
        }
        super.addTooltipInfo(stack, level, tooltip);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return this.getStoredXp(stack) > 0;
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrength) {
        float knowledgeLoss = (float)(100 - (Integer)SharedConfigTombstone.magic_item.scrollOfKnowledgeLoss.get()) / 100.0f;
        boolean valid = this.setStoredXp(stack, (int)((float)EntityHelper.getPlayerTotalXp((PlayerEntity)player) * knowledgeLoss));
        if (valid) {
            player.field_71068_ca = 0;
            player.field_71067_cb = 0;
            player.field_71106_cc = 0.0f;
            player.field_71144_ck = -1;
            return ISoulConsumer.ConsumeResult.success((ITextComponent)LangKey.MESSAGE_LOSE_EXPERIENCE_SUCCESS.getText(new Object[0]), 1);
        }
        return ISoulConsumer.ConsumeResult.fail((ITextComponent)LangKey.MESSAGE_LOSE_EXPERIENCE_FAILED.getText(new Object[0]));
    }

    @Override
    protected boolean doEffects(ServerWorld world, ServerPlayerEntity player, ItemStack stack, @Nullable LivingEntity target) {
        int i;
        int storedXp;
        ServerPlayerEntity targetPlayer = Optional.ofNullable(target).filter(EntityHelper::isValidServerPlayer).map(ServerPlayerEntity.class::cast).orElse(player);
        if (!targetPlayer.equals((Object)player)) {
            ModTriggers.CAST_ON_ALLY.trigger(player);
        }
        if ((storedXp = this.getStoredXp(stack)) > (i = Integer.MAX_VALUE - targetPlayer.field_71067_cb)) {
            LangKey.MESSAGE_EARN_EXPERIENCE_FAILED.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        EntityHelper.setPlayerXp((PlayerEntity)targetPlayer, EntityHelper.getPlayerTotalXp((PlayerEntity)player) + storedXp);
        LangKey.MESSAGE_EARN_EXPERIENCE_SUCCESS.sendMessage((PlayerEntity)targetPlayer, new Object[0]);
        ModTriggers.USE_KNOWLEDGE.trigger(player);
        return true;
    }

    public int getStoredXp(ItemStack stack) {
        return Math.max(NBTStackHelper.getInteger(stack, "stored_xp"), 0);
    }

    public boolean setStoredXp(ItemStack stack, int xp) {
        if (stack.func_77973_b() == this && xp > 0) {
            NBTStackHelper.setInteger(stack, "stored_xp", xp);
            return true;
        }
        return false;
    }

    @Override
    protected boolean isTargetForCasting(PlayerEntity player, LivingEntity target) {
        return EntityHelper.isValidPlayer((Entity)target);
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, CompoundNBT tag, LootContext context) {
        tag.func_74768_a("stored_xp", Helper.RANDOM.nextInt((Integer)ConfigTombstone.loot.maxXpLostPage.get()) + 1);
        tag.func_74757_a("is_loot", true);
        return stack;
    }

    public ItemStack createWithXp(int xp) {
        ItemStack stack = new ItemStack((IItemProvider)this);
        stack.func_196082_o().func_74768_a("stored_xp", xp);
        return stack;
    }
}

