/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemSmokeBall
extends ItemGeneric {
    public ItemSmokeBall() {
        super("smoke_ball", () -> SharedConfigTombstone.allowed_magic_items.allowSmokeBall.get());
        this.withDefaultInfo().withBetaInfo();
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_77973_b() == this) {
            level.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187797_fA, SoundCategory.NEUTRAL, 0.5f, 0.4f / (Helper.RANDOM.nextFloat() * 0.4f + 0.8f));
            if (!level.field_72995_K) {
                SnowballEntity snowball = new SnowballEntity(level, (LivingEntity)player);
                snowball.func_213884_b(heldStack.func_77946_l());
                snowball.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
                level.func_217376_c((Entity)snowball);
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            if (!player.field_71075_bZ.field_75098_d) {
                heldStack.func_190918_g(1);
            }
            return ActionResult.func_233538_a_((Object)heldStack, (boolean)level.func_201670_d());
        }
        return ActionResult.func_226251_d_((Object)heldStack);
    }

    public void func_77622_d(ItemStack stack, World level, PlayerEntity player) {
        if (!level.func_201670_d() && stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("color", 3)) {
            ModTriggers.COLOR_SMOKE_BALL.trigger((ServerPlayerEntity)player);
        }
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        return ActionResultType.FAIL;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        return Optional.ofNullable(context.func_195999_j()).map(player -> this.func_77659_a(context.func_195991_k(), (PlayerEntity)player, context.func_221531_n()).func_188397_a()).orElse(ActionResultType.FAIL);
    }

    public int getColor(ItemStack stack, int tint) {
        return NBTStackHelper.getInteger(stack, "color", 0x808080);
    }

    public void setColor(ItemStack stack, int color) {
        int oldColor = NBTStackHelper.getInteger(stack, "color", -1);
        NBTStackHelper.setInteger(stack, "color", oldColor >= 0 ? Helper.combineColor(oldColor, color) : color);
    }
}

