/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfRecall
extends ItemTablet {
    private static final String TOMB_POS_NBT_LOCATION = "tombPos";

    public ItemTabletOfRecall() {
        super("tablet_of_recall", () -> SharedConfigTombstone.allowed_magic_items.allowTabletOfRecall.get());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addTooltipInfo(ItemStack stack, World level, List<ITextComponent> tooltip) {
        this.addItemDesc(tooltip);
        boolean isAncient = this.isAncient(stack);
        if (isAncient) {
            this.addItemDesc(tooltip, "_ancient", new Object[0]);
        }
        if (!this.isEnchanted(stack)) {
            this.addItemUse(tooltip, "1", new Object[0]);
        } else {
            this.addItemPosition(tooltip, this.getTombPos(stack));
            this.addItemUse(tooltip, "2", new Object[0]);
            this.addItemUse(tooltip, "3", new Object[0]);
        }
        super.addTooltipInfo(stack, level, tooltip);
    }

    private boolean setTombPos(ItemStack stack, Location location) {
        if (stack.func_77973_b() == this && !location.isOrigin()) {
            NBTStackHelper.setLocation(stack, TOMB_POS_NBT_LOCATION, location);
            return true;
        }
        return false;
    }

    public Location getTombPos(ItemStack stack) {
        if (stack.func_77973_b() == this) {
            return NBTStackHelper.getLocation(stack, TOMB_POS_NBT_LOCATION);
        }
        return Location.ORIGIN;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return !this.getTombPos(stack).isOrigin();
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrength) {
        boolean valid = this.setTombPos(stack, new Location(gravePos, world));
        if (valid) {
            this.setUseCount(stack, this.getUseMax());
            if (!this.isAncient(stack) && soulStrength > 1) {
                NBTStackHelper.setBoolean(stack, "ancient", true);
                return ISoulConsumer.ConsumeResult.success((ITextComponent)LangKey.MESSAGE_ITEM_BOUND_TO_PLACE.getText(new Object[0]), 2);
            }
            return ISoulConsumer.ConsumeResult.success((ITextComponent)LangKey.MESSAGE_ITEM_BOUND_TO_PLACE.getText(new Object[0]), 1);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    public void onSneakGrave(World world, BlockPos gravePos, PlayerEntity player, ItemStack stack) {
        if (!world.func_201670_d() && this.isEnchanted(stack) && !EntityHelper.hasGlobalItemCooldown(player, this)) {
            this.setTombPos(stack, new Location(gravePos, world));
            EntityHelper.setGlobalItemCooldown(player, this, 100);
            LangKey.MESSAGE_ITEM_BOUND_TO_PLACE.sendMessage(player, StyleType.MESSAGE_NORMAL, new Object[0]);
        }
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!player.func_225608_bj_()) {
            return super.func_77659_a(world, player, hand);
        }
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    @Override
    protected boolean doEffects(ServerWorld world, ServerPlayerEntity player, ItemStack stack, @Nullable LivingEntity target) {
        MinecraftServer server;
        ServerWorld targetWorld;
        Location location = this.getTombPos(stack);
        if (location.isOrigin()) {
            LangKey.MESSAGE_INVALID_LOCATION.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        boolean isSameDim = location.isSameDimension((World)world);
        if (isSameDim) {
            if (location.isInRange(player.func_233580_cy_(), 10)) {
                LangKey.MESSAGE_TELEPORT_TOO_CLOSE_FROM_GRAVE.sendMessage((PlayerEntity)player, new Object[0]);
                return false;
            }
        } else if (!((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue()) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        if (!Helper.isValidPos((World)(targetWorld = (server = Objects.requireNonNull(player.func_184102_h())).func_71218_a(location.dim)), location.getPos())) {
            LangKey.MESSAGE_INVALID_LOCATION.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        CallbackHandler.addFastCallback(() -> {
            boolean isAncient = this.isAncient(stack);
            ServerPlayerEntity newPlayer = Helper.teleportToGrave(player, location, targetWorld);
            if (isAncient) {
                Location home = new Location((Entity)newPlayer);
                world.func_175674_a((Entity)player, player.func_174813_aQ().func_72314_b(3.0, 0.0, 3.0), e -> e.func_70089_S() && e.func_184222_aU() && !e.func_175149_v()).forEach(entity -> Helper.teleportEntity(entity, home, targetWorld));
            }
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((PlayerEntity)newPlayer, new Object[0]);
            ModTriggers.USE_RECALL.trigger(player);
        });
        return true;
    }

    @Override
    protected CastingType getCastingType(ItemStack stack) {
        return this.isAncient(stack) ? CastingType.AREA_TELEPORT : CastingType.SIMPLE_TELEPORT;
    }
}

