/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.EntityHelper;

public class KnowledgeRewardFunction
extends LootFunction {
    public static final ResourceLocation RL = new ResourceLocation("tombstone", "reward_knowledge");
    public static final Serializer SERIALIZER = new Serializer();
    private final int points;

    protected KnowledgeRewardFunction(ILootCondition[] conditions, int points) {
        super(conditions);
        this.points = points;
    }

    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
        Entity thisEntity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (EntityHelper.isValidServerPlayer(thisEntity)) {
            assert (thisEntity != null);
            thisEntity.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward((ServerPlayerEntity)thisEntity, this.points, 0));
        }
        return stack;
    }

    public LootFunctionType func_230425_b_() {
        return ModTombstone.KNOWLEDGE_REWARD;
    }

    public static class Serializer
    extends LootFunction.Serializer<KnowledgeRewardFunction> {
        public KnowledgeRewardFunction deserialize(JsonObject json, JsonDeserializationContext deserializationContext, ILootCondition[] conditionsIn) {
            return new KnowledgeRewardFunction(conditionsIn, JSONUtils.func_151208_a((JsonObject)json, (String)"points", (int)0));
        }

        public void serialize(JsonObject json, KnowledgeRewardFunction fct, JsonSerializationContext serializationContext) {
            super.func_230424_a_(json, (LootFunction)fct, serializationContext);
            json.addProperty("points", (Number)fct.points);
        }
    }
}

