/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.item.ItemScrollBuff;

public class RandomScrollBuffFunction
extends LootFunction {
    public static final ResourceLocation RL = new ResourceLocation("tombstone", "random_scroll_buff");
    public static final Serializer SERIALIZER = new Serializer();
    private final boolean isAncient;

    protected RandomScrollBuffFunction(ILootCondition[] conditions, boolean isAncient) {
        super(conditions);
        this.isAncient = isAncient;
    }

    public LootFunctionType func_230425_b_() {
        return ModTombstone.RANDOM_SCROLL_BUFF;
    }

    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
        return ItemScrollBuff.SpellBuff.getRandomEnchantedScroll(true).orElse(stack);
    }

    public static class Serializer
    extends LootFunction.Serializer<RandomScrollBuffFunction> {
        public RandomScrollBuffFunction deserialize(JsonObject json, JsonDeserializationContext deserializationContext, ILootCondition[] conditionsIn) {
            return new RandomScrollBuffFunction(conditionsIn, JSONUtils.func_151209_a((JsonObject)json, (String)"ancient", (boolean)false));
        }

        public void serialize(JsonObject json, RandomScrollBuffFunction fct, JsonSerializationContext serializationContext) {
            super.func_230424_a_(json, (LootFunction)fct, serializationContext);
            json.addProperty("ancient", Boolean.valueOf(fct.isAncient));
        }
    }

    public static class Builder
    extends LootFunction.Builder<Builder> {
        private final boolean isAncient;

        public Builder(boolean isAncient) {
            this.isAncient = isAncient;
        }

        protected Builder getThis() {
            return this;
        }

        public ILootFunction func_216052_b() {
            return new RandomScrollBuffFunction(this.func_216053_g(), this.isAncient);
        }
    }
}

