/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.registry.ModEffects;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Inject(method={"isAlliedTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodIsAlliedTo(Entity entity, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (entity == null) {
            callbackInfoReturnable.setReturnValue((Object)false);
        } else if ((Entity)this instanceof LivingEntity && entity instanceof LivingEntity && EntityHelper.areOwnerOrServants((LivingEntity)this, (LivingEntity)entity)) {
            callbackInfoReturnable.setReturnValue((Object)true);
        }
    }

    @Inject(method={"isInvisibleTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodIsInvisibleTo(PlayerEntity player, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (EffectHelper.isPotionActive((LivingEntity)player, ModEffects.ghostly_shape) || EffectHelper.isPotionActive((LivingEntity)player, ModEffects.true_sight)) {
            callbackInfoReturnable.setReturnValue((Object)false);
        }
    }
}

