/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SMessagePlayerPreference;

public class CMessageLogin {
    private final TimeHelper.SpecialEvent specialEvent;

    public CMessageLogin(TimeHelper.SpecialEvent specialEvent) {
        this.specialEvent = specialEvent;
    }

    static CMessageLogin fromBytes(PacketBuffer buf) {
        return new CMessageLogin(TimeHelper.SpecialEvent.byId(buf.readShort()));
    }

    static void toBytes(CMessageLogin msg, PacketBuffer buf) {
        buf.writeShort(msg.specialEvent.ordinal());
    }

    public static class Handler {
        static void handle(final CMessageLogin message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        TimeHelper.setSpecialEvent(message.specialEvent);
                        PacketHandler.sendToServer(new SMessagePlayerPreference(ModTombstone.PROXY.initPlayerPreference(), true));
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

