/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.tombstone.capability.FriendlyAnimalProvider;
import ovh.corail.tombstone.capability.ServantEntityProvider;
import ovh.corail.tombstone.helper.Helper;

public class CMessageServant {
    private final int entityId;
    private final UUID uuid;
    private final boolean isServant;

    public CMessageServant(int entityId, UUID uuid, boolean isServant) {
        this.entityId = entityId;
        this.uuid = uuid;
        this.isServant = isServant;
    }

    static CMessageServant fromBytes(PacketBuffer buf) {
        return new CMessageServant(buf.func_150792_a(), buf.func_179253_g(), buf.readBoolean());
    }

    static void toBytes(CMessageServant msg, PacketBuffer buf) {
        buf.func_150787_b(msg.entityId);
        buf.func_179252_a(msg.uuid);
        buf.writeByte((int)((byte)(msg.isServant ? 1 : 0)));
    }

    public static class Handler {
        static void handle(final CMessageServant msg, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        Entity entity;
                        Entity entity2 = entity = Minecraft.func_71410_x().field_71441_e != null ? Minecraft.func_71410_x().field_71441_e.func_73045_a(msg.entityId) : null;
                        if (entity != null) {
                            if (msg.isServant) {
                                entity.getCapability(ServantEntityProvider.SERVANT_ENTITY_CAPABILITY).ifPresent(cap -> cap.setOwnerId(msg.uuid));
                            } else {
                                entity.getCapability(FriendlyAnimalProvider.FRIENDLY_ANIMAL_CAPABILITY).ifPresent(cap -> cap.setOwnerId(msg.uuid));
                            }
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

