/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.capability.SpellCasterProvider;
import ovh.corail.tombstone.helper.Helper;

public class CMessageSpellCasting {
    private final int entityId;
    private final int color;

    public CMessageSpellCasting(int entityId, int color) {
        this.entityId = entityId;
        this.color = color;
    }

    static CMessageSpellCasting fromBytes(PacketBuffer buf) {
        return new CMessageSpellCasting(buf.func_150792_a(), buf.readInt());
    }

    static void toBytes(CMessageSpellCasting msg, PacketBuffer buf) {
        buf.func_150787_b(msg.entityId);
        buf.writeInt(msg.color);
    }

    public static class Handler {
        static void handle(final CMessageSpellCasting msg, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        ModTombstone.PROXY.getClientWorld().map(level -> level.func_73045_a(msg.entityId)).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).ifPresent(caster -> caster.getCapability(SpellCasterProvider.SPELLCASTER_CAPABILITY).ifPresent(c -> {
                            c.setCastingColor(msg.color);
                            if (c.isCasting()) {
                                ModTombstone.PROXY.produceParticleCasting(1.0, msg.color, (LivingEntity)caster, e -> !c.isCasting());
                            }
                        }));
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

