/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;

public class SMessageResetPerk {
    private final Vector3d vec;
    private final Direction direction;
    private final BlockPos pos;
    private final boolean isInside;

    public SMessageResetPerk(Vector3d vec, Direction direction, BlockPos pos, boolean isInside) {
        this.vec = vec;
        this.direction = direction;
        this.pos = pos;
        this.isInside = isInside;
    }

    static SMessageResetPerk fromBytes(PacketBuffer buf) {
        return new SMessageResetPerk(new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble()), Direction.values()[MathHelper.func_76125_a((int)(buf.readByte() & 0xFF), (int)0, (int)(Direction.values().length - 1))], buf.func_179259_c(), buf.readBoolean());
    }

    static void toBytes(SMessageResetPerk msg, PacketBuffer buf) {
        buf.writeDouble(msg.vec.field_72450_a);
        buf.writeDouble(msg.vec.field_72448_b);
        buf.writeDouble(msg.vec.field_72449_c);
        buf.writeByte(msg.direction.ordinal());
        buf.func_179255_a(msg.pos);
        buf.writeBoolean(msg.isInside);
    }

    static class Handler {
        Handler() {
        }

        static void handle(final SMessageResetPerk message, Supplier<NetworkEvent.Context> contextSupplier) {
            final NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToServer(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        BlockState state;
                        BlockRayTraceResult result;
                        ServerPlayerEntity player = ctx.getSender();
                        if (player != null && player.func_184614_ca().func_77973_b() == ModItems.ankh_of_pray && (result = new BlockRayTraceResult(message.vec, message.direction, message.pos, message.isInside)).func_237486_a_((Entity)player) < 25.0 && ModBlocks.DECORATIVE_GRAVES.containsValue((state = player.field_70170_p.func_180495_p(message.pos)).func_177230_c())) {
                            state.func_177230_c().func_225533_a_(state, player.field_70170_p, message.pos, (PlayerEntity)player, Hand.MAIN_HAND, result);
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

