/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.network.CMessageTBCapability;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.registry.ModTriggers;

public class SMessageUpgradePerk {
    private final SyncType syncType;
    private final Perk perk;

    public SMessageUpgradePerk(SyncType syncType, Perk perk) {
        this.syncType = syncType;
        this.perk = perk;
    }

    static SMessageUpgradePerk fromBytes(PacketBuffer buf) {
        return new SMessageUpgradePerk(buf.readBoolean() ? SyncType.DOWNGRADE_PERK : SyncType.UPGRADE_PERK, (Perk)PerkRegistry.perkRegistry.getValue((int)buf.readShort()));
    }

    static void toBytes(SMessageUpgradePerk msg, PacketBuffer buf) {
        buf.writeBoolean(msg.syncType == SyncType.DOWNGRADE_PERK);
        buf.writeShort(PerkRegistry.perkRegistry.getID((IForgeRegistryEntry)msg.perk));
    }

    public static class Handler {
        static void handle(final SMessageUpgradePerk message, Supplier<NetworkEvent.Context> contextSupplier) {
            final NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToServer(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        ServerPlayerEntity player = ctx.getSender();
                        if (player != null) {
                            player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> {
                                int levelPerk = cap.getPerkLevel((PlayerEntity)player, message.perk);
                                int totalPerkPoints = cap.getTotalPerkPoints();
                                if (message.syncType == SyncType.UPGRADE_PERK && levelPerk < Math.min(message.perk.getLevelMax(), EntityHelper.getPerkLevelMaxForKnowledge(totalPerkPoints)) && totalPerkPoints - cap.getUsedPerkPoints((PlayerEntity)player) >= message.perk.getCost(levelPerk + 1)) {
                                    cap.setPerk(message.perk, levelPerk + 1);
                                    ModTriggers.SELECTED_PERKS.trigger(player);
                                    PacketHandler.sendToPlayer(new CMessageTBCapability(CMessageTBCapability.SyncType.SET_PERK, message.perk, levelPerk + 1), player);
                                } else if (message.syncType == SyncType.DOWNGRADE_PERK && levelPerk > 0 && player.func_184812_l_()) {
                                    cap.setPerk(message.perk, levelPerk - 1);
                                    PacketHandler.sendToPlayer(new CMessageTBCapability(CMessageTBCapability.SyncType.SET_PERK, message.perk, levelPerk - 1), player);
                                }
                            });
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }

    public static enum SyncType {
        UPGRADE_PERK,
        DOWNGRADE_PERK;

    }
}

