/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.particle.CustomParticle;

@OnlyIn(value=Dist.CLIENT)
public final class ParticleMagicCircle
extends CustomParticle {
    private static final ResourceLocation COMMON_TEXTURE = new ResourceLocation("tombstone", "textures/aura/aura1.png");
    private static final double HEIGHT = 0.13;
    private final WeakReference<LivingEntity> entityWeakReference;
    private final Predicate<LivingEntity> requireRemoval;

    public ParticleMagicCircle(ClientWorld level, CastingType castingType, LivingEntity entity, Predicate<LivingEntity> requireRemoval) {
        super(level, entity.func_226277_ct_(), entity.func_226278_cu_() + 0.13, entity.func_226281_cx_());
        this.entityWeakReference = new WeakReference<LivingEntity>(entity);
        this.requireRemoval = requireRemoval;
        this.func_70541_f((float)(castingType.radius * 5.0));
        this.setRolling(0.0f, 0.009738938f);
        this.func_70538_b(castingType.r, castingType.g, castingType.b);
    }

    @Override
    protected void updatePosition() {
        Optional.ofNullable(this.entityWeakReference.get()).ifPresent(e -> this.func_187109_b(e.func_226277_ct_(), e.func_226278_cu_() + 0.13, e.func_226281_cx_()));
    }

    @Override
    protected boolean requireRemoval() {
        return Optional.ofNullable(this.entityWeakReference.get()).map(this.requireRemoval::test).orElse(true);
    }

    @Override
    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        if (this.field_70546_d > 1) {
            super.func_225606_a_(buffer, renderInfo, partialTicks);
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return COMMON_TEXTURE;
    }

    @Override
    protected Quaternion getRollQuaternion(ActiveRenderInfo renderInfo, float partialTicks) {
        if (this.field_190014_F == 0.0f) {
            return Quaternion.field_227060_a_;
        }
        Quaternion rollTransform = new Quaternion(Quaternion.field_227060_a_);
        rollTransform.func_195890_a(Vector3f.field_229181_d_.func_229193_c_(MathHelper.func_219799_g((float)partialTicks, (float)this.field_190015_G, (float)this.field_190014_F)));
        return rollTransform;
    }

    @Override
    protected Vector3f[] getFaceQuad() {
        return new Vector3f[]{new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(-1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, -1.0f)};
    }

    @Override
    protected void addQuad(IVertexBuilder buffer, Vector3f[] points, int light) {
        super.addQuad(buffer, points, light);
        super.addQuad(buffer, new Vector3f[]{points[3], points[2], points[1], points[0]}, light);
    }
}

