/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.recipe;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.recipe.DisableableShapelessRecipe;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModSerializers;

public class RecipeColoredSmoke
extends DisableableShapelessRecipe {
    public RecipeColoredSmoke(ShapelessRecipe recipe) {
        super(recipe);
    }

    @Override
    public boolean func_77569_a(CraftingInventory inv, World world) {
        if (ModItems.smoke_ball.isEnabled()) {
            boolean smokeBallFound = false;
            boolean dyeFound = false;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                if (stack.func_77973_b() == ModItems.smoke_ball) {
                    if (smokeBallFound) {
                        return false;
                    }
                    smokeBallFound = true;
                    continue;
                }
                if (Tags.Items.DYES.func_230235_a_((Object)stack.func_77973_b())) {
                    dyeFound = true;
                    continue;
                }
                return false;
            }
            return smokeBallFound && dyeFound;
        }
        return false;
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        ArrayList<Integer> dyes = new ArrayList<Integer>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == ModItems.smoke_ball) {
                int oldColor = ModItems.smoke_ball.getColor(stack, 0);
                if (oldColor < 0) continue;
                dyes.add(oldColor);
                continue;
            }
            if (!(stack.func_77973_b() instanceof DyeItem)) continue;
            dyes.add(((DyeItem)stack.func_77973_b()).func_195962_g().func_196060_f());
        }
        ItemStack smokeBall = this.func_77571_b().func_77946_l();
        ModItems.smoke_ball.setColor(smokeBall, Helper.combineColor(Ints.toArray(dyes)));
        return smokeBall;
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return ModSerializers.COLORED_SMOKE;
    }
}

