/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.SkeletonModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.entity.GraveGuardian;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModItems;

@OnlyIn(value=Dist.CLIENT)
public class GraveGuardianArmorLayer<T extends GraveGuardian, M extends SkeletonModel<T>>
extends BipedArmorLayer<T, M, SkeletonModel<T>> {
    private final SkeletonModel<T> innerModel;
    private final SkeletonModel<T> outerModel;

    public GraveGuardianArmorLayer(IEntityRenderer<T, M> parent) {
        this(parent, new SkeletonModel(0.5f, true), new SkeletonModel(1.0f, true));
    }

    public GraveGuardianArmorLayer(IEntityRenderer<T, M> parent, SkeletonModel<T> innerModel, SkeletonModel<T> outerModel) {
        super(parent, innerModel, outerModel);
        this.innerModel = innerModel;
        this.outerModel = outerModel;
    }

    public void render(MatrixStack poseStack, IRenderTypeBuffer bufferSource, int light, T graveGuardian, float p_117100_, float p_117101_, float p_117102_, float p_117103_, float p_117104_, float p_117105_) {
        this.renderArmorPiece(poseStack, bufferSource, graveGuardian, EquipmentSlotType.CHEST, light, this.getArmorModel(EquipmentSlotType.CHEST));
        this.renderArmorPiece(poseStack, bufferSource, graveGuardian, EquipmentSlotType.LEGS, light, this.getArmorModel(EquipmentSlotType.LEGS));
        this.renderArmorPiece(poseStack, bufferSource, graveGuardian, EquipmentSlotType.FEET, light, this.getArmorModel(EquipmentSlotType.FEET));
        this.renderArmorPiece(poseStack, bufferSource, graveGuardian, EquipmentSlotType.HEAD, light, this.getArmorModel(EquipmentSlotType.HEAD));
    }

    private void renderArmorPiece(MatrixStack poseStack, IRenderTypeBuffer bufferSource, T graveGuardian, EquipmentSlotType slot, int light, SkeletonModel<T> model) {
        if (slot == EquipmentSlotType.HEAD && TimeHelper.isDateAroundChristmas()) {
            poseStack.func_227860_a_();
            ((SkeletonModel)this.func_215332_c()).func_205072_a().func_228307_a_(poseStack);
            this.translateToHead(poseStack);
            Minecraft.func_71410_x().func_175597_ag().func_228397_a_(graveGuardian, new ItemStack((IItemProvider)ModItems.christmas_hat), ItemCameraTransforms.TransformType.HEAD, false, poseStack, bufferSource, 0xF000F0);
            poseStack.func_227865_b_();
            return;
        }
        ItemStack stack = ((GraveGuardian)((Object)graveGuardian)).func_184582_a(slot);
        if (stack.func_77973_b() instanceof ArmorItem) {
            if (((ArmorItem)stack.func_77973_b()).func_185083_B_() == slot) {
                float b;
                float g;
                float r;
                model = (SkeletonModel)this.getArmorModelHook((LivingEntity)graveGuardian, stack, slot, (BipedModel)model);
                ((SkeletonModel)this.func_215332_c()).func_217148_a((BipedModel)model);
                this.func_188359_a((BipedModel)model, slot);
                boolean hasFoil = false;
                IVertexBuilder vertexconsumer = ItemRenderer.func_239386_a_((IRenderTypeBuffer)bufferSource, (RenderType)RenderType.func_239263_a_((ResourceLocation)this.getArmorResource((Entity)graveGuardian, stack, slot, null)), (boolean)false, (boolean)hasFoil);
                if (TimeHelper.isDateAroundHalloween()) {
                    r = 1.0f;
                    g = 0.4f;
                    b = 0.0f;
                    light = 0xF000F0;
                } else if (TimeHelper.isDateAroundChristmas()) {
                    r = 1.0f;
                    g = 0.0f;
                    b = 0.0f;
                    light = 0xF000F0;
                } else {
                    r = 0.0f;
                    g = 1.0f;
                    b = 1.0f;
                }
                model.func_225598_a_(poseStack, vertexconsumer, light, OverlayTexture.field_229196_a_, r, g, b, 1.0f);
            } else if (stack.func_77973_b() == Items.field_221697_cK) {
                poseStack.func_227860_a_();
                ((SkeletonModel)this.func_215332_c()).func_205072_a().func_228307_a_(poseStack);
                this.translateToHead(poseStack);
                Minecraft.func_71410_x().func_175597_ag().func_228397_a_(graveGuardian, stack, ItemCameraTransforms.TransformType.HEAD, false, poseStack, bufferSource, 0xF000F0);
                poseStack.func_227865_b_();
            }
        }
    }

    private void translateToHead(MatrixStack poseStack) {
        poseStack.func_227861_a_(0.0, -0.25, 0.0);
        poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        float scale = 0.625f;
        poseStack.func_227862_a_(scale, -scale, -scale);
    }

    private SkeletonModel<T> getArmorModel(EquipmentSlotType slot) {
        return slot == EquipmentSlotType.LEGS ? this.innerModel : this.outerModel;
    }
}

