/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.spawner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.village.VillageSiege;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.village.VillageSiegeEvent;
import net.minecraftforge.eventbus.api.Event;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.event.EventFactory;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;

public class CustomVillageSiege
extends VillageSiege {
    private SiegeState siegeState = SiegeState.SIEGE_END;
    private boolean hasFailedTrySiege = false;
    private int nextSpawnTime = 0;
    private int siegeCount = 0;
    private int spawnX;
    private int spawnY;
    private int spawnZ;

    private static void sendDevLog(String message) {
        if (((Boolean)ConfigTombstone.village_siege.logSiegeState.get()).booleanValue()) {
            ModTombstone.LOGGER.info(message);
        }
    }

    public boolean startSiege(int chance) {
        if (this.siegeState == SiegeState.SIEGE_START || this.siegeState == SiegeState.SPAWN_MOBS) {
            CustomVillageSiege.sendDevLog("A siege is already in progress");
            return false;
        }
        CustomVillageSiege.sendDevLog("Launching a village siege");
        if (Helper.getRandom(1, 100) <= chance) {
            this.siegeState = SiegeState.SIEGE_START;
            CustomVillageSiege.sendDevLog("Random chance: Siege started");
        } else {
            this.siegeState = SiegeState.SIEGE_END;
            CustomVillageSiege.sendDevLog("Random chance: Siege aborted");
        }
        this.hasFailedTrySiege = false;
        return this.siegeState == SiegeState.SIEGE_START;
    }

    public boolean stopSiege() {
        if (this.siegeState == SiegeState.SIEGE_END) {
            CustomVillageSiege.sendDevLog("No siege in progress");
            return false;
        }
        this.siegeState = SiegeState.SIEGE_END;
        this.hasFailedTrySiege = false;
        return true;
    }

    public int func_230253_a_(ServerWorld serverWorld, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
        if (!serverWorld.func_72935_r() && spawnHostileMobs) {
            float angle = serverWorld.func_242415_f(0.0f);
            if ((double)angle == 0.5) {
                this.startSiege((Integer)ConfigTombstone.village_siege.siegeChance.get());
            }
            if (this.siegeState == SiegeState.SIEGE_END) {
                return 0;
            }
            if (this.siegeState == SiegeState.SIEGE_START) {
                if ((Integer)ConfigTombstone.village_siege.delaySiegeTest.get() > 0 && this.hasFailedTrySiege && !TimeHelper.atInterval((World)serverWorld, (int)((Integer)ConfigTombstone.village_siege.delaySiegeTest.get()))) {
                    return 0;
                }
                if (!this.trySetupSiege(serverWorld)) {
                    return 0;
                }
                if (EventFactory.onVillageSiegeStart(serverWorld, new BlockPos(this.spawnX, this.spawnY, this.spawnZ))) {
                    CustomVillageSiege.sendDevLog("Try to siege: tombstone event canceled");
                    return 0;
                }
                this.siegeState = SiegeState.SPAWN_MOBS;
                CustomVillageSiege.sendDevLog("Spawning " + ConfigTombstone.village_siege.siegeMaxCreature.get() + " zombie" + ((Integer)ConfigTombstone.village_siege.siegeMaxCreature.get() > 1 ? "s" : ""));
            }
            if (this.siegeState == SiegeState.SPAWN_MOBS) {
                if (this.nextSpawnTime > 0) {
                    --this.nextSpawnTime;
                    return 0;
                }
                this.nextSpawnTime = 2;
                if (this.siegeCount > 0) {
                    this.spawnZombie(serverWorld);
                    --this.siegeCount;
                } else {
                    this.siegeState = SiegeState.SIEGE_END;
                    CustomVillageSiege.sendDevLog("Siege ended");
                }
            }
            return 1;
        }
        this.siegeState = SiegeState.SIEGE_END;
        this.hasFailedTrySiege = false;
        return 0;
    }

    private boolean trySetupSiege(ServerWorld serverWorld) {
        ArrayList playerList = new ArrayList(serverWorld.func_217369_A());
        if (((Boolean)ConfigTombstone.village_siege.shufflePlayersForSiege.get()).booleanValue()) {
            Collections.shuffle(playerList, Helper.RANDOM);
        }
        for (ServerPlayerEntity player : playerList) {
            BlockPos blockpos;
            if (player.func_175149_v() || player.func_184812_l_() && !((Boolean)ConfigTombstone.village_siege.allowCreativePlayersForSiege.get()).booleanValue() || !serverWorld.func_217483_b_(blockpos = player.func_233580_cy_()) || serverWorld.func_226691_t_(blockpos).func_201856_r() == Biome.Category.MUSHROOM) continue;
            float angle = serverWorld.field_73012_v.nextFloat() * ((float)Math.PI * 2);
            float radius = 32.0f;
            this.spawnX = blockpos.func_177958_n() + MathHelper.func_76141_d((float)(MathHelper.func_76134_b((float)angle) * radius));
            this.spawnY = blockpos.func_177956_o();
            this.spawnZ = blockpos.func_177952_p() + MathHelper.func_76141_d((float)(MathHelper.func_76126_a((float)angle) * radius));
            Vector3d siegeLocation = this.findRandomSpawnPos(serverWorld, new BlockPos(this.spawnX, this.spawnY, this.spawnZ));
            if (siegeLocation == null) continue;
            if (MinecraftForge.EVENT_BUS.post((Event)new VillageSiegeEvent((VillageSiege)this, (World)serverWorld, (PlayerEntity)player, siegeLocation))) {
                CustomVillageSiege.sendDevLog("Try to siege: forge event canceled");
                break;
            }
            this.nextSpawnTime = 0;
            this.siegeCount = (Integer)ConfigTombstone.village_siege.siegeMaxCreature.get();
            return true;
        }
        this.hasFailedTrySiege = true;
        CustomVillageSiege.sendDevLog("Try to siege: failed");
        return false;
    }

    private void spawnZombie(ServerWorld serverWorld) {
        Vector3d Vector3d2 = this.findRandomSpawnPos(serverWorld, new BlockPos(this.spawnX, this.spawnY, this.spawnZ));
        if (Vector3d2 != null) {
            ZombieEntity mob = (ZombieEntity)EntityType.field_200725_aD.func_200721_a((World)serverWorld);
            if (mob == null) {
                return;
            }
            mob.func_213386_a((IServerWorld)serverWorld, serverWorld.func_175649_E(mob.func_233580_cy_()), SpawnReason.EVENT, null, null);
            if (((Boolean)ConfigTombstone.village_siege.persistentMobInSiege.get()).booleanValue()) {
                mob.func_110163_bv();
            }
            if (((Boolean)ConfigTombstone.village_siege.undeadWearHelmInSiege.get()).booleanValue() && mob.func_184582_a(EquipmentSlotType.HEAD).func_190926_b()) {
                Difficulty difficulty = serverWorld.func_175659_aa();
                mob.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)(difficulty == Difficulty.HARD ? Items.field_151161_ac : (difficulty == Difficulty.NORMAL ? Items.field_151028_Y : Items.field_151024_Q))));
            }
            mob.func_70012_b(Vector3d2.field_72450_a, Vector3d2.field_72448_b, Vector3d2.field_72449_c, serverWorld.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (EventFactory.onVillageSiegeZombieSpawn(serverWorld, mob)) {
                return;
            }
            mob.getPersistentData().func_74757_a("siege", true);
            serverWorld.func_242417_l((Entity)mob);
            if (((Boolean)ConfigTombstone.village_siege.glowingCreatureTest.get()).booleanValue()) {
                EffectHelper.addEffect((LivingEntity)mob, Effects.field_188423_x, 10000);
            }
        }
    }

    @Nullable
    private Vector3d findRandomSpawnPos(ServerWorld serverWorld, BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            int z;
            int y;
            int x = pos.func_177958_n() + serverWorld.field_73012_v.nextInt(16) - 8;
            BlockPos blockpos = new BlockPos(x, y = serverWorld.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z = pos.func_177952_p() + serverWorld.field_73012_v.nextInt(16) - 8), z);
            if (!serverWorld.func_217483_b_(blockpos) || !MonsterEntity.func_223325_c((EntityType)EntityType.field_200725_aD, (IServerWorld)serverWorld, (SpawnReason)SpawnReason.EVENT, (BlockPos)blockpos, (Random)serverWorld.field_73012_v)) continue;
            return Vector3d.func_237492_c_((Vector3i)blockpos);
        }
        return null;
    }

    public static enum SiegeState {
        SIEGE_START,
        SIEGE_END,
        SPAWN_MOBS;

    }
}

