/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.industrialagriculture.silentsmechanisms.config;

import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.github.elrol.industrialagriculture.IndustrialAgriculture;
import com.github.elrol.industrialagriculture.config.MainConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.loading.FMLPaths;

public class Config {
    private static final File file = new File(FMLPaths.CONFIGDIR.get().toFile(), "/IndustrialAgriculture");
    private final Map<String, String> tierMap = new HashMap<String, String>();
    private final Map<String, String> cruxMap = new HashMap<String, String>();

    public void init() {
        IndustrialAgriculture.LOGGER.info("Initializing Init Config");
        this.tierMap.put("bismuth", "THREE");
        this.tierMap.put("redstone_alloy", "FOUR");
        this.tierMap.put("compressed_iron", "FOUR");
        this.tierMap.put("refined_iron", "FOUR");
        this.tierMap.put("bismuth_brass", "FOUR");
        this.tierMap.put("bismuth_steel", "FOUR");
        this.tierMap.put("aluminum_steel", "FOUR");
        this.cruxMap.put("bismuth", "");
        this.cruxMap.put("redstone_alloy", "");
        this.cruxMap.put("compressed_iron", "");
        this.cruxMap.put("refined_iron", "");
        this.cruxMap.put("bismuth_brass", "");
        this.cruxMap.put("bismuth_steel", "");
        this.cruxMap.put("aluminum_steel", "");
        this.save();
    }

    public CropTier getCropTier(String name) {
        if (!this.tierMap.containsKey(name)) {
            return CropTier.ONE;
        }
        return MainConfig.getCropTier((String)this.tierMap.get(name));
    }

    public Map<String, String> getCruxMap() {
        return this.cruxMap;
    }

    public void save() {
        IndustrialAgriculture.LOGGER.info("Saving Config");
        if (!file.exists()) {
            file.mkdirs();
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            String jsonString = gson.toJson((Object)this);
            FileWriter writer = new FileWriter(new File(file, "SilentsMechanisms.json"));
            writer.write(jsonString);
            writer.close();
        }
        catch (IOException e) {
            System.out.println("exception " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Config load() {
        IndustrialAgriculture.LOGGER.info("Loading Config");
        File f = new File(file, "SilentsMechanisms.json");
        Gson gson = new GsonBuilder().create();
        BufferedReader bufferedReader = null;
        if (f.exists()) {
            Config config = new Config();
            if (!f.canWrite()) {
                f.setWritable(true);
            }
            try {
                bufferedReader = new BufferedReader(new FileReader(f));
                config = (Config)gson.fromJson((Reader)bufferedReader, new TypeToken<Config>(){}.getType());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (config == null) {
                config = new Config();
                config.init();
                return config;
            }
            return config;
        }
        Config config = new Config();
        config.init();
        return config;
    }
}

