/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.generator;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.silentchaos512.mechanisms.api.IFluidContainer;
import net.silentchaos512.mechanisms.api.RedstoneMode;
import net.silentchaos512.mechanisms.block.generator.AbstractGeneratorTileEntity;
import net.silentchaos512.mechanisms.config.Config;
import net.silentchaos512.mechanisms.util.InventoryUtils;
import net.silentchaos512.mechanisms.util.MachineTier;
import net.silentchaos512.utils.EnumUtils;

public abstract class AbstractFluidFuelGeneratorTileEntity
extends AbstractGeneratorTileEntity {
    public static final int FIELDS_COUNT = 9;
    protected final FluidTank tank;
    private final LazyOptional<IFluidHandler> fluidHandlerCap;
    protected final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return AbstractFluidFuelGeneratorTileEntity.this.getEnergyStored() & 0xFFFF;
                }
                case 1: {
                    return AbstractFluidFuelGeneratorTileEntity.this.getEnergyStored() >> 16 & 0xFFFF;
                }
                case 2: {
                    return AbstractFluidFuelGeneratorTileEntity.this.getMaxEnergyStored() & 0xFFFF;
                }
                case 3: {
                    return AbstractFluidFuelGeneratorTileEntity.this.getMaxEnergyStored() >> 16 & 0xFFFF;
                }
                case 4: {
                    return AbstractFluidFuelGeneratorTileEntity.this.redstoneMode.ordinal();
                }
                case 5: {
                    return AbstractFluidFuelGeneratorTileEntity.this.burnTime;
                }
                case 6: {
                    return AbstractFluidFuelGeneratorTileEntity.this.totalBurnTime;
                }
                case 7: {
                    return Registry.field_212619_h.func_148757_b((Object)AbstractFluidFuelGeneratorTileEntity.this.tank.getFluid().getFluid());
                }
                case 8: {
                    return AbstractFluidFuelGeneratorTileEntity.this.tank.getFluidAmount();
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 4: {
                    AbstractFluidFuelGeneratorTileEntity.this.redstoneMode = (RedstoneMode)EnumUtils.byOrdinal((int)value, (Enum)RedstoneMode.IGNORED);
                    break;
                }
                case 5: {
                    AbstractFluidFuelGeneratorTileEntity.this.burnTime = value;
                    break;
                }
                case 6: {
                    AbstractFluidFuelGeneratorTileEntity.this.totalBurnTime = value;
                }
            }
        }

        public int func_221478_a() {
            return 9;
        }
    };

    protected AbstractFluidFuelGeneratorTileEntity(TileEntityType<?> typeIn, int inventorySize, int maxEnergy, int maxReceive, int maxExtract, FluidTank tankIn) {
        super(typeIn, inventorySize, maxEnergy, maxReceive, maxExtract, MachineTier.STANDARD);
        this.tank = tankIn;
        this.fluidHandlerCap = LazyOptional.of(() -> this.tank);
    }

    protected abstract int getFuelBurnTime(FluidStack var1);

    protected void tryFillTank(ItemStack item) {
        FluidStack fluid = IFluidContainer.getBucketOrContainerFluid(item);
        if (this.canAcceptFluidContainer(item, fluid)) {
            this.tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
            ItemStack output = this.func_70301_a(1);
            if (output.func_190926_b()) {
                this.func_70299_a(1, item.getContainerItem());
            } else {
                output.func_190917_f(1);
            }
            item.func_190918_g(1);
        }
    }

    private boolean canAcceptFluidContainer(ItemStack item, FluidStack fluid) {
        ItemStack output = this.func_70301_a(1);
        return !(fluid.isEmpty() || !this.tank.isFluidValid(0, fluid) || this.tank.fill(fluid, IFluidHandler.FluidAction.SIMULATE) != fluid.getAmount() || !output.func_190926_b() && !InventoryUtils.canItemsStack(item.getContainerItem(), output) || !output.func_190926_b() && output.func_190916_E() >= output.func_77976_d());
    }

    @Override
    protected void consumeFuel() {
        FluidStack fluid = this.tank.drain(((Integer)Config.fluidGeneratorInjectionVolume.get()).intValue(), IFluidHandler.FluidAction.EXECUTE);
        this.burnTime = this.totalBurnTime = this.getFuelBurnTime(fluid);
    }

    @Override
    public void func_73660_a() {
        ItemStack stack;
        if (this.tank.getFluidAmount() < this.tank.getTankCapacity(0) - 999 && !(stack = this.func_70301_a(0)).func_190926_b()) {
            this.tryFillTank(stack);
        }
        super.func_73660_a();
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tags) {
        super.func_230337_a_(state, tags);
        if (tags.func_74764_b("FluidTank")) {
            this.tank.setFluid(FluidStack.loadFluidStackFromNBT((CompoundNBT)tags.func_74775_l("FluidTank")));
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tags) {
        tags.func_218657_a("FluidTank", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        return super.func_189515_b(tags);
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        CompoundNBT tags = packet.func_148857_g();
        if (tags.func_74764_b("FluidTank")) {
            this.tank.setFluid(FluidStack.loadFluidStackFromNBT((CompoundNBT)tags.func_74775_l("FluidTank")));
        }
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT tags = super.func_189517_E_();
        tags.func_218657_a("FluidTank", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        return tags;
    }

    @Override
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandlerCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.fluidHandlerCap.invalidate();
    }
}

