/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.generator.diesel;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.silentchaos512.mechanisms.api.IFluidContainer;
import net.silentchaos512.mechanisms.block.generator.AbstractFluidFuelGeneratorTileEntity;
import net.silentchaos512.mechanisms.block.generator.diesel.DieselGeneratorContainer;
import net.silentchaos512.mechanisms.init.ModTileEntities;
import net.silentchaos512.mechanisms.util.InventoryUtils;
import net.silentchaos512.mechanisms.util.TextUtil;

public class DieselGeneratorTileEntity
extends AbstractFluidFuelGeneratorTileEntity {
    public static final int MAX_ENERGY = 50000;
    public static final int MAX_SEND = 500;
    public static final int ENERGY_CREATED_PER_TICK = 120;
    public static final int TICKS_PER_MILLIBUCKET = 10;
    static final ITag.INamedTag<Fluid> FUEL_TAG = FluidTags.func_206956_a((String)new ResourceLocation("forge", "diesel").toString());

    public DieselGeneratorTileEntity() {
        super(ModTileEntities.dieselGenerator, 2, 50000, 0, 500, new FluidTank(4000, s -> s.getFluid().func_207185_a(FUEL_TAG)));
    }

    @Override
    protected boolean hasFuel() {
        return this.tank.getFluidAmount() > 0;
    }

    @Override
    protected int getFuelBurnTime(FluidStack fluid) {
        return 10 * fluid.getAmount();
    }

    @Override
    protected int getEnergyCreatedPerTick() {
        return 120;
    }

    public int[] func_180463_a(Direction side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return index == 0 && InventoryUtils.isFilledFluidContainer(stack) && this.tank.isFluidValid(IFluidContainer.getBucketOrContainerFluid(stack));
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 1;
    }

    protected ITextComponent func_213907_g() {
        return TextUtil.translate("container", "diesel_generator", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new DieselGeneratorContainer(id, player, this, this.fields);
    }
}

