/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.compat.jei;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.mechanisms.block.infuser.InfuserScreen;
import net.silentchaos512.mechanisms.crafting.recipe.InfusingRecipe;
import net.silentchaos512.mechanisms.init.ModBlocks;
import net.silentchaos512.mechanisms.init.ModItems;
import net.silentchaos512.mechanisms.item.CanisterItem;
import net.silentchaos512.mechanisms.util.Constants;
import net.silentchaos512.mechanisms.util.TextUtil;

public class InfusingRecipeCategory
implements IRecipeCategory<InfusingRecipe> {
    private static final int GUI_START_X = 7;
    private static final int GUI_START_Y = 15;
    private static final int GUI_WIDTH = 129;
    private static final int GUI_HEIGHT = 60;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final String localizedName;

    public InfusingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(InfuserScreen.TEXTURE, 7, 15, 129, 60);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(ModBlocks.INFUSER));
        this.arrow = guiHelper.drawableBuilder(InfuserScreen.TEXTURE, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.localizedName = TextUtil.translate("jei", "category.infusing", new Object[0]).getString();
    }

    public ResourceLocation getUid() {
        return Constants.INFUSING;
    }

    public Class<? extends InfusingRecipe> getRecipeClass() {
        return InfusingRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(InfusingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getFluidIngredient().getFluids()));
        ingredients.setOutputLists(VanillaTypes.FLUID, recipe.getFluidOutputs().stream().map(Collections::singletonList).collect(Collectors.toList()));
        ImmutableList emptyContainers = ImmutableList.of((Object)new ItemStack((IItemProvider)Items.field_151133_ar), (Object)new ItemStack(ModItems.EMPTY_CANISTER));
        ArrayList feedstockContainers = new ArrayList();
        recipe.getFluidIngredient().getFluids().forEach(fluid -> InfusingRecipeCategory.addFluidContainers(feedstockContainers, fluid.getFluid()));
        ingredients.setInputLists(VanillaTypes.ITEM, Arrays.asList(feedstockContainers, Arrays.asList(recipe.getIngredient().func_193365_a())));
        ingredients.setOutputLists(VanillaTypes.ITEM, Arrays.asList(emptyContainers, Collections.singletonList(recipe.func_77571_b())));
    }

    public void setRecipe(IRecipeLayout recipeLayout, InfusingRecipe recipe, IIngredients ingredients) {
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        int capacity = 4000;
        fluidStacks.init(0, true, 25, 5, 12, 50, 4000, true, null);
        fluidStacks.set(0, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 1, -7);
        itemStacks.init(1, false, 1, 44);
        itemStacks.init(2, true, 47, 20);
        itemStacks.init(3, false, 109, 20);
        itemStacks.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        itemStacks.set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        itemStacks.set(2, (List)ingredients.getInputs(VanillaTypes.ITEM).get(1));
        itemStacks.set(3, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(1));
    }

    public void draw(InfusingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.arrow.draw(matrixStack, 72, 20);
    }

    private static void addFluidContainers(Collection<ItemStack> list, Fluid fluid) {
        ItemStack bucket = new ItemStack((IItemProvider)fluid.func_204524_b());
        if (!bucket.func_190926_b()) {
            list.add(bucket);
        }
        list.add(CanisterItem.getStack(fluid));
    }
}

