/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.compat.jei;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.mechanisms.api.crafting.recipe.fluid.FluidIngredient;
import net.silentchaos512.mechanisms.block.mixer.MixerScreen;
import net.silentchaos512.mechanisms.crafting.recipe.MixingRecipe;
import net.silentchaos512.mechanisms.init.ModBlocks;
import net.silentchaos512.mechanisms.init.ModItems;
import net.silentchaos512.mechanisms.item.CanisterItem;
import net.silentchaos512.mechanisms.util.Constants;
import net.silentchaos512.mechanisms.util.TextUtil;

public class MixingRecipeCategory
implements IRecipeCategory<MixingRecipe> {
    private static final int GUI_START_X = 5;
    private static final int GUI_START_Y = 13;
    private static final int GUI_WIDTH = 148;
    private static final int GUI_HEIGHT = 65;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final String localizedName;

    public MixingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(MixerScreen.TEXTURE, 5, 13, 148, 65);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(ModBlocks.MIXER));
        this.arrow = guiHelper.drawableBuilder(MixerScreen.TEXTURE, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.localizedName = TextUtil.translate("jei", "category.mixing", new Object[0]).getString();
    }

    public ResourceLocation getUid() {
        return Constants.MIXING;
    }

    public Class<? extends MixingRecipe> getRecipeClass() {
        return MixingRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(MixingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.FLUID, recipe.getFluidIngredients().stream().map(FluidIngredient::getFluids).collect(Collectors.toList()));
        ingredients.setOutputLists(VanillaTypes.FLUID, recipe.getFluidOutputs().stream().map(Collections::singletonList).collect(Collectors.toList()));
        ImmutableList emptyContainers = ImmutableList.of((Object)new ItemStack((IItemProvider)Items.field_151133_ar), (Object)new ItemStack(ModItems.EMPTY_CANISTER));
        ArrayList feedstockContainers = new ArrayList();
        recipe.getFluidIngredients().stream().flatMap(ingredient -> ingredient.getFluids().stream()).forEach(stack -> MixingRecipeCategory.addFluidContainers(feedstockContainers, stack.getFluid()));
        ingredients.setInputLists(VanillaTypes.ITEM, Arrays.asList(feedstockContainers, emptyContainers));
        ArrayList outputContainers = new ArrayList();
        recipe.getFluidOutputs().forEach(fluid -> MixingRecipeCategory.addFluidContainers(outputContainers, fluid.getFluid()));
        ingredients.setOutputLists(VanillaTypes.ITEM, Arrays.asList(emptyContainers, outputContainers));
    }

    public void setRecipe(IRecipeLayout recipeLayout, MixingRecipe recipe, IIngredients ingredients) {
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        int capacity = 4000;
        fluidStacks.init(0, true, 24, 5, 12, 50, 4000, true, null);
        fluidStacks.init(1, true, 40, 5, 12, 50, 4000, true, null);
        fluidStacks.init(2, true, 56, 5, 12, 50, 4000, true, null);
        fluidStacks.init(3, true, 72, 5, 12, 50, 4000, true, null);
        fluidStacks.init(4, false, 112, 5, 12, 50, 4000, true, null);
        List inputs = ingredients.getInputs(VanillaTypes.FLUID);
        for (int i = 0; i < inputs.size(); ++i) {
            fluidStacks.set(i, (List)inputs.get(i));
        }
        fluidStacks.set(4, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(0));
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 2, 2);
        itemStacks.init(1, false, 2, 45);
        itemStacks.init(2, true, 128, 2);
        itemStacks.init(3, false, 128, 45);
        itemStacks.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        itemStacks.set(2, (List)ingredients.getInputs(VanillaTypes.ITEM).get(1));
        itemStacks.set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        itemStacks.set(3, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(1));
    }

    public void draw(MixingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.arrow.draw(matrixStack, 87, 22);
    }

    private static void addFluidContainers(Collection<ItemStack> list, Fluid fluid) {
        ItemStack bucket = new ItemStack((IItemProvider)fluid.func_204524_b());
        if (!bucket.func_190926_b()) {
            list.add(bucket);
        }
        list.add(CanisterItem.getStack(fluid));
    }
}

