/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.crafting.recipe;

import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.mechanisms.api.crafting.recipe.fluid.FluidIngredient;
import net.silentchaos512.mechanisms.api.crafting.recipe.fluid.IFluidInventory;
import net.silentchaos512.mechanisms.api.crafting.recipe.fluid.IFluidRecipe;
import net.silentchaos512.mechanisms.init.ModRecipes;

public class MixingRecipe
implements IFluidRecipe<IFluidInventory> {
    private final ResourceLocation recipeId;
    private int processTime;
    private final List<FluidIngredient> ingredients = NonNullList.func_191196_a();
    private FluidStack result;

    public MixingRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public boolean matches(IFluidInventory inv, World worldIn) {
        int inputTanks = Math.min(4, inv.getTanks());
        HashSet<Integer> matchedTanks = new HashSet<Integer>();
        block0: for (FluidIngredient ingredient : this.ingredients) {
            for (int i = 0; i < inputTanks; ++i) {
                FluidStack stack = inv.getFluidInTank(i);
                if (matchedTanks.contains(i) || !ingredient.test(stack)) continue;
                matchedTanks.add(i);
                continue block0;
            }
        }
        return matchedTanks.size() == this.ingredients.size();
    }

    @Override
    public List<FluidStack> getFluidResults(IFluidInventory inv) {
        return this.getFluidOutputs();
    }

    @Override
    public List<FluidStack> getFluidOutputs() {
        return Collections.singletonList(this.result.copy());
    }

    @Override
    public List<FluidIngredient> getFluidIngredients() {
        return Collections.unmodifiableList(this.ingredients);
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.MIXING.get();
    }

    public IRecipeType<?> func_222127_g() {
        return ModRecipes.Types.MIXING;
    }

    public boolean func_192399_d() {
        return true;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<MixingRecipe> {
        public MixingRecipe read(ResourceLocation recipeId, JsonObject json) {
            MixingRecipe recipe = new MixingRecipe(recipeId);
            recipe.processTime = JSONUtils.func_151203_m((JsonObject)json, (String)"process_time");
            JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients").forEach(e -> recipe.ingredients.add(FluidIngredient.deserialize(e.getAsJsonObject())));
            recipe.result = IFluidRecipe.deserializeFluid(JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return recipe;
        }

        @Nullable
        public MixingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            MixingRecipe recipe = new MixingRecipe(recipeId);
            recipe.processTime = buffer.func_150792_a();
            int ingredientCount = buffer.readByte();
            for (int i = 0; i < ingredientCount; ++i) {
                recipe.ingredients.add(FluidIngredient.read(buffer));
            }
            recipe.result = IFluidRecipe.readFluid(buffer);
            return recipe;
        }

        public void write(PacketBuffer buffer, MixingRecipe recipe) {
            buffer.func_150787_b(recipe.processTime);
            buffer.writeByte(recipe.ingredients.size());
            recipe.ingredients.forEach(ingredient -> ingredient.write(buffer));
            IFluidRecipe.writeFluid(buffer, recipe.result);
        }
    }
}

