/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.lib.util.NameUtils;
import net.silentchaos512.mechanisms.init.ModRecipes;

public final class CrushingRecipeBuilder {
    private final Map<ItemStack, Float> results = new LinkedHashMap<ItemStack, Float>();
    private final Ingredient ingredient;
    private final int processTime;

    private CrushingRecipeBuilder(Ingredient ingredient, int processTime) {
        this.ingredient = ingredient;
        this.processTime = processTime;
    }

    public static CrushingRecipeBuilder builder(IItemProvider ingredient, int processTime) {
        return CrushingRecipeBuilder.builder(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ingredient}), processTime);
    }

    public static CrushingRecipeBuilder builder(ITag<Item> ingredient, int processTime) {
        return CrushingRecipeBuilder.builder(Ingredient.func_199805_a(ingredient), processTime);
    }

    public static CrushingRecipeBuilder builder(Ingredient ingredient, int processTime) {
        return new CrushingRecipeBuilder(ingredient, processTime);
    }

    public static CrushingRecipeBuilder crushingChunks(ITag<Item> chunks, IItemProvider dust, int processTime, float extraChance) {
        return CrushingRecipeBuilder.builder(chunks, processTime).result(dust, 1).result(dust, 1, extraChance);
    }

    public static CrushingRecipeBuilder crushingIngot(ITag<Item> ingot, IItemProvider dust, int processTime) {
        return CrushingRecipeBuilder.builder(ingot, processTime).result(dust, 1);
    }

    public static CrushingRecipeBuilder crushingOre(ITag<Item> ore, IItemProvider chunks, int processTime, @Nullable IItemProvider extra, float extraChance) {
        CrushingRecipeBuilder builder = CrushingRecipeBuilder.builder(ore, processTime);
        builder.result(chunks, 2);
        if (extra != null) {
            builder.result(extra, 1, extraChance);
        }
        return builder;
    }

    public static CrushingRecipeBuilder crushingOre(IItemProvider ore, IItemProvider chunks, int processTime, @Nullable IItemProvider extra, float extraChance) {
        CrushingRecipeBuilder builder = CrushingRecipeBuilder.builder(ore, processTime);
        builder.result(chunks, 2);
        if (extra != null) {
            builder.result(extra, 1, extraChance);
        }
        return builder;
    }

    public CrushingRecipeBuilder result(IItemProvider item, int count, float chance) {
        this.results.put(new ItemStack(item, count), Float.valueOf(chance));
        return this;
    }

    public CrushingRecipeBuilder result(IItemProvider item, int count) {
        return this.result(item, count, 1.0f);
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        ResourceLocation resultId = NameUtils.fromItem((ItemStack)this.results.keySet().iterator().next());
        ResourceLocation id = new ResourceLocation("minecraft".equals(resultId.func_110624_b()) ? "silents_mechanisms" : resultId.func_110624_b(), "crushing/" + resultId.func_110623_a());
        this.build(consumer, id);
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this));
    }

    public class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final CrushingRecipeBuilder builder;

        public Result(ResourceLocation id, CrushingRecipeBuilder builder) {
            this.id = id;
            this.builder = builder;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("process_time", (Number)this.builder.processTime);
            json.add("ingredient", this.builder.ingredient.func_200304_c());
            JsonArray results = new JsonArray();
            this.builder.results.forEach((stack, chance) -> results.add((JsonElement)this.serializeResult((ItemStack)stack, chance.floatValue())));
            json.add("results", (JsonElement)results);
        }

        private JsonObject serializeResult(ItemStack stack, float chance) {
            JsonObject json = new JsonObject();
            json.addProperty("item", NameUtils.fromItem((ItemStack)stack).toString());
            if (stack.func_190916_E() > 1) {
                json.addProperty("count", (Number)stack.func_190916_E());
            }
            if (chance < 1.0f) {
                json.addProperty("chance", (Number)Float.valueOf(chance));
            }
            return json;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)ModRecipes.CRUSHING.get();
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

