/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.wireless.blocks;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.rftoolsbase.api.xnet.keys.NetworkId;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.xnet.client.ControllerChannelClientInfo;
import mcjty.xnet.compat.XNetTOPDriver;
import mcjty.xnet.logic.LogicTools;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.controller.blocks.TileEntityController;
import mcjty.xnet.modules.router.blocks.TileEntityRouter;
import mcjty.xnet.modules.wireless.WirelessRouterModule;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.WirelessChannelKey;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import mcjty.xnet.multiblock.XNetWirelessChannels;
import mcjty.xnet.setup.Config;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;

public final class TileEntityWirelessRouter
extends TickingTileEntity {
    public static final int TIER_INVALID = -1;
    public static final int TIER_1 = 0;
    public static final int TIER_2 = 1;
    public static final int TIER_INF = 2;
    private boolean error = false;
    private int counter = 10;
    @GuiValue(name="public")
    private boolean publicAccess = false;
    private int globalChannelVersion = -1;
    @Cap(type=CapType.ENERGY)
    private final LazyOptional<GenericEnergyStorage> energyHandler = LazyOptional.of(() -> new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)Config.wirelessRouterMaxRF.get()).intValue(), (long)((Integer)Config.wirelessRouterRfPerTick.get()).intValue()));
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Wireless Router").containerSupplier(DefaultContainerProvider.empty(WirelessRouterModule.CONTAINER_WIRELESS_ROUTER, (GenericTileEntity)this)).setupSync((GenericTileEntity)this));

    public TileEntityWirelessRouter() {
        super((TileEntityType)WirelessRouterModule.TYPE_WIRELESS_ROUTER.get());
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().topDriver((TOPDriver)XNetTOPDriver.DRIVER).tileEntitySupplier(TileEntityWirelessRouter::new).manualEntry(ManualHelper.create((String)"xnet:simple/wireless/wireless_router")).info(new InfoLine[]{TooltipBuilder.key((String)"message.xnet.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()})){

            protected void func_206840_a(@Nonnull StateContainer.Builder<Block, BlockState> builder) {
                super.func_206840_a(builder);
                builder.func_206894_a(new Property[]{TileEntityController.ERROR});
            }
        };
    }

    public boolean isPublicAccess() {
        return this.publicAccess;
    }

    public void setPublicAccess(boolean publicAccess) {
        this.publicAccess = publicAccess;
        this.func_70296_d();
    }

    public void tickServer() {
        NetworkId networkId;
        --this.counter;
        if (this.counter > 0) {
            return;
        }
        this.counter = 10;
        int version = XNetWirelessChannels.get(this.field_145850_b).getGlobalChannelVersion();
        if (this.globalChannelVersion != version) {
            this.globalChannelVersion = version;
            NetworkId networkId2 = this.findRoutingNetwork();
            if (networkId2 != null) {
                WorldBlob worldBlob = XNetBlobData.get(this.field_145850_b).getWorldBlob(this.field_145850_b);
                worldBlob.markNetworkDirty(networkId2);
            }
        }
        boolean err = false;
        int range = this.getAntennaRange();
        if (range < 0) {
            err = true;
        }
        if (!err && (networkId = this.findRoutingNetwork()) != null) {
            LogicTools.consumers(this.field_145850_b, networkId).forEach(consumerPos -> LogicTools.routers(this.field_145850_b, consumerPos).forEach(r -> this.publishChannels((TileEntityRouter)((Object)((Object)r)), networkId)));
        }
        this.setError(err);
    }

    private int getAntennaTier() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c() != WirelessRouterModule.ANTENNA_BASE.get()) {
            return -1;
        }
        Block aboveAntenna = this.field_145850_b.func_180495_p(this.field_174879_c.func_177981_b(2)).func_177230_c();
        if (aboveAntenna == WirelessRouterModule.ANTENNA_DISH.get()) {
            return 2;
        }
        if (aboveAntenna != WirelessRouterModule.ANTENNA.get()) {
            return -1;
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177981_b(3)).func_177230_c() == WirelessRouterModule.ANTENNA.get()) {
            return 1;
        }
        return 0;
    }

    private int getAntennaRange() {
        int tier = this.getAntennaTier();
        switch (tier) {
            case -1: {
                return -1;
            }
            case 0: {
                return (Integer)Config.antennaTier1Range.get();
            }
            case 1: {
                return (Integer)Config.antennaTier2Range.get();
            }
            case 2: {
                return Integer.MAX_VALUE;
            }
        }
        return -1;
    }

    private boolean inRange(TileEntityWirelessRouter otherRouter) {
        int thisRange = this.getAntennaRange();
        int otherRange = otherRouter.getAntennaRange();
        if (thisRange >= Integer.MAX_VALUE && otherRange >= Integer.MAX_VALUE) {
            return true;
        }
        if (thisRange <= 0 || otherRange <= 0) {
            return false;
        }
        if (!this.field_145850_b.func_234923_W_().equals(otherRouter.field_145850_b.func_234923_W_())) {
            return false;
        }
        double maxSqdist = Math.min(thisRange, otherRange);
        maxSqdist *= maxSqdist;
        double sqdist = this.field_174879_c.func_177951_i((Vector3i)otherRouter.field_174879_c);
        return sqdist <= maxSqdist;
    }

    private boolean inRange(XNetWirelessChannels.WirelessRouterInfo wirelessRouter) {
        ServerWorld otherWorld = LevelTools.getLevel((World)this.field_145850_b, (RegistryKey)wirelessRouter.getCoordinate().func_239646_a_());
        if (otherWorld == null) {
            return false;
        }
        return LogicTools.consumers((World)otherWorld, wirelessRouter.getNetworkId()).filter(arg_0 -> TileEntityWirelessRouter.lambda$inRange$4((World)otherWorld, arg_0)).anyMatch(arg_0 -> this.lambda$inRange$5((World)otherWorld, arg_0));
    }

    public void findRemoteChannelInfo(List<ControllerChannelClientInfo> list) {
        NetworkId network = this.findRoutingNetwork();
        if (network == null) {
            return;
        }
        XNetWirelessChannels wirelessData = XNetWirelessChannels.get(this.field_145850_b);
        wirelessData.findChannels(this.getOwnerUUID()).forEach(channel -> channel.getRouters().values().stream().filter(routerInfo -> this.isDifferentRouter(network, (XNetWirelessChannels.WirelessRouterInfo)routerInfo)).filter(this::inRange).forEach(routerInfo -> {
            ServerWorld otherWorld = LevelTools.getLevel((World)this.field_145850_b, (RegistryKey)routerInfo.getCoordinate().func_239646_a_());
            LogicTools.consumers((World)otherWorld, routerInfo.getNetworkId()).filter(arg_0 -> ((World)otherWorld).func_175667_e(arg_0)).forEach(arg_0 -> TileEntityWirelessRouter.lambda$findRemoteChannelInfo$8((World)otherWorld, list, arg_0));
        }));
    }

    private boolean isDifferentRouter(NetworkId thisNetwork, XNetWirelessChannels.WirelessRouterInfo routerInfo) {
        return !routerInfo.getCoordinate().func_239646_a_().equals(this.field_145850_b.func_234923_W_()) || !thisNetwork.equals((Object)routerInfo.getNetworkId());
    }

    private void publishChannels(TileEntityRouter router, NetworkId networkId) {
        int tier = this.getAntennaTier();
        UUID ownerUUID = this.publicAccess ? null : this.getOwnerUUID();
        XNetWirelessChannels wirelessData = XNetWirelessChannels.get(this.field_145850_b);
        this.energyHandler.ifPresent(h -> router.publishedChannelStream().forEach(pair -> {
            String name = (String)pair.getKey();
            IChannelType channelType = (IChannelType)pair.getValue();
            long energyStored = h.getEnergy();
            if ((long)((Integer)Config.wirelessRouterRfPerChannel[tier].get()).intValue() <= energyStored) {
                h.consumeEnergy((long)((Integer)Config.wirelessRouterRfPerChannel[tier].get()).intValue());
                wirelessData.transmitChannel(name, channelType, ownerUUID, (RegistryKey<World>)this.field_145850_b.func_234923_W_(), this.field_174879_c, networkId);
            }
        }));
    }

    public void addWirelessConnectors(Map<SidedConsumer, IConnectorSettings> connectors, String channelName, IChannelType type, @Nullable UUID owner, @Nonnull Map<WirelessChannelKey, Integer> wirelessVersions) {
        WirelessChannelKey key = new WirelessChannelKey(channelName, type, owner);
        XNetWirelessChannels.WirelessChannelInfo info = XNetWirelessChannels.get(this.field_145850_b).findChannel(key);
        if (info != null) {
            info.getRouters().keySet().stream().filter(routerPos -> !routerPos.func_239646_a_().equals(this.field_145850_b.func_234923_W_()) || !routerPos.func_218180_b().equals((Object)this.field_174879_c)).filter(routerPos -> LevelTools.isLoaded((World)LevelTools.getLevel((World)this.field_145850_b, (RegistryKey)routerPos.func_239646_a_()), (BlockPos)routerPos.func_218180_b())).forEach(routerPos -> {
                NetworkId routingNetwork;
                TileEntityWirelessRouter otherRouter;
                ServerWorld otherWorld = LevelTools.getLevel((World)this.field_145850_b, (RegistryKey)routerPos.func_239646_a_());
                TileEntity otherTE = otherWorld.func_175625_s(routerPos.func_218180_b());
                if (otherTE instanceof TileEntityWirelessRouter && this.inRange(otherRouter = (TileEntityWirelessRouter)otherTE) && !otherRouter.inError() && (routingNetwork = otherRouter.findRoutingNetwork()) != null) {
                    LogicTools.consumers(this.field_145850_b, routingNetwork).forEach(consumerPos -> LogicTools.routers((World)otherWorld, consumerPos).forEach(router -> {
                        if (router.addConnectorsFromConnectedNetworks(connectors, channelName, type)) {
                            wirelessVersions.put(key, info.getVersion());
                        }
                    }));
                }
            });
        }
    }

    private void setError(boolean err) {
        if (this.error != err) {
            this.error = err;
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (this.error) {
                if (!((Boolean)state.func_177229_b((Property)TileEntityController.ERROR)).booleanValue()) {
                    this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(true)), 3);
                }
            } else if (((Boolean)state.func_177229_b((Property)TileEntityController.ERROR)).booleanValue()) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(false)), 3);
            }
            this.markDirtyQuick();
        }
    }

    public boolean inError() {
        return this.error;
    }

    @Nullable
    public NetworkId findRoutingNetwork() {
        WorldBlob worldBlob = XNetBlobData.get(this.field_145850_b).getWorldBlob(this.field_145850_b);
        return LogicTools.routingConnectors(this.field_145850_b, this.func_174877_v()).findFirst().map(worldBlob::getNetworkAt).orElse(null);
    }

    public void saveAdditional(@Nonnull CompoundNBT tagCompound) {
        tagCompound.func_74757_a("error", this.error);
        super.saveAdditional(tagCompound);
    }

    public void load(CompoundNBT tagCompound) {
        super.load(tagCompound);
        this.error = tagCompound.func_74767_n("error");
    }

    public void saveInfo(CompoundNBT tagCompound) {
        super.saveInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74757_a("publicAcc", this.publicAccess);
    }

    public void loadInfo(CompoundNBT tagCompound) {
        super.loadInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.publicAccess = info.func_74767_n("publicAcc");
    }

    public void onReplaced(World world, BlockPos pos, BlockState state, BlockState newstate) {
        if (state.func_177230_c() == newstate.func_177230_c()) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            XNetBlobData blobData = XNetBlobData.get(this.field_145850_b);
            WorldBlob worldBlob = blobData.getWorldBlob(this.field_145850_b);
            worldBlob.removeCableSegment(pos);
            blobData.save();
        }
    }

    public void onBlockPlacedBy(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, placer, stack);
        if (!world.field_72995_K) {
            XNetBlobData blobData = XNetBlobData.get(world);
            WorldBlob worldBlob = blobData.getWorldBlob(world);
            NetworkId networkId = worldBlob.newNetwork();
            worldBlob.createNetworkProvider(pos, new ColorId(CableColor.ROUTING.ordinal() + 1), networkId);
            blobData.save();
        }
    }

    public BlockState getActualState(BlockState state) {
        return (BlockState)state.func_206870_a((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(this.inError()));
    }

    private static /* synthetic */ void lambda$findRemoteChannelInfo$8(World otherWorld, List list, BlockPos consumerPos) {
        LogicTools.routers(otherWorld, consumerPos).forEach(router -> router.findLocalChannelInfo(list, true, true));
    }

    private /* synthetic */ boolean lambda$inRange$5(World otherWorld, BlockPos consumerPos) {
        return LogicTools.wirelessRouters(otherWorld, consumerPos).anyMatch(this::inRange);
    }

    private static /* synthetic */ boolean lambda$inRange$4(World otherWorld, BlockPos consumerPos) {
        return LevelTools.isLoaded((World)otherWorld, (BlockPos)consumerPos);
    }
}

