/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.multiblock;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.xnet.keys.ConsumerId;
import mcjty.rftoolsbase.api.xnet.keys.NetworkId;
import mcjty.rftoolsbase.api.xnet.net.IWorldBlob;
import mcjty.xnet.multiblock.BlobId;
import mcjty.xnet.multiblock.ChunkBlob;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.IntPos;
import mcjty.xnet.multiblock.VersionNumber;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class WorldBlob
implements IWorldBlob {
    private final RegistryKey<World> dimensionType;
    private final Map<Long, ChunkBlob> chunkBlobMap = new HashMap<Long, ChunkBlob>();
    private int lastNetworkId = 0;
    private int lastConsumerId = 0;
    private final Map<NetworkId, Set<BlockPos>> consumersOnNetwork = new HashMap<NetworkId, Set<BlockPos>>();
    private final Map<NetworkId, VersionNumber> networkVersions = new HashMap<NetworkId, VersionNumber>();
    private final Map<ConsumerId, BlockPos> consumerPositions = new HashMap<ConsumerId, BlockPos>();
    private final Map<NetworkId, BlockPos> providerPositions = new HashMap<NetworkId, BlockPos>();

    public WorldBlob(RegistryKey<World> dimensionType) {
        this.dimensionType = dimensionType;
    }

    public RegistryKey<World> getDimensionType() {
        return this.dimensionType;
    }

    @Nonnull
    public NetworkId newNetwork() {
        ++this.lastNetworkId;
        return new NetworkId(this.lastNetworkId);
    }

    @Nonnull
    public ConsumerId newConsumer() {
        ++this.lastConsumerId;
        return new ConsumerId(this.lastConsumerId);
    }

    @Nullable
    public BlobId getBlobAt(@Nonnull BlockPos pos) {
        ChunkBlob blob = this.getBlob(pos);
        if (blob == null) {
            return null;
        }
        IntPos intPos = new IntPos(pos);
        return blob.getBlobIdForPosition(intPos);
    }

    @Nonnull
    public Set<NetworkId> getNetworksAt(@Nonnull BlockPos pos) {
        ChunkBlob blob = this.getBlob(pos);
        if (blob == null) {
            return Collections.emptySet();
        }
        IntPos intPos = new IntPos(pos);
        return blob.getNetworksForPosition(intPos);
    }

    @Nullable
    public NetworkId getNetworkAt(@Nonnull BlockPos pos) {
        Set<NetworkId> networks = this.getNetworksAt(pos);
        if (networks.isEmpty()) {
            return null;
        }
        return networks.iterator().next();
    }

    @Nullable
    public ConsumerId getConsumerAt(@Nonnull BlockPos pos) {
        ChunkBlob blob = this.getBlob(pos);
        if (blob == null) {
            return null;
        }
        IntPos intPos = new IntPos(pos);
        return blob.getNetworkConsumers().get(intPos);
    }

    @Nullable
    public ColorId getColorAt(@Nonnull BlockPos pos) {
        ChunkBlob blob = this.getBlob(pos);
        if (blob == null) {
            return null;
        }
        IntPos intPos = new IntPos(pos);
        return blob.getColorIdForPosition(intPos);
    }

    @Nullable
    public BlockPos getProviderPosition(@Nonnull NetworkId networkId) {
        if (!this.providerPositions.containsKey(networkId)) {
            this.providerPositions.put(networkId, null);
            for (ChunkBlob blob : this.chunkBlobMap.values()) {
                IntPos intPos = blob.getProviderPosition(networkId);
                if (intPos == null) continue;
                this.providerPositions.put(networkId, blob.getPosition(intPos));
                break;
            }
        }
        return this.providerPositions.get(networkId);
    }

    @Nonnull
    public Set<BlockPos> getConsumers(NetworkId network) {
        if (!this.consumersOnNetwork.containsKey(network)) {
            HashSet<BlockPos> positions = new HashSet<BlockPos>();
            for (ChunkBlob blob : this.chunkBlobMap.values()) {
                Set<IntPos> consumersForNetwork = blob.getConsumersForNetwork(network);
                for (IntPos intPos : consumersForNetwork) {
                    BlockPos pos = blob.getPosition(intPos);
                    positions.add(pos);
                }
            }
            this.consumersOnNetwork.put(network, positions);
        }
        return this.consumersOnNetwork.get(network);
    }

    private void removeCachedNetworksForBlob(ChunkBlob blob) {
        for (NetworkId id : blob.getNetworks()) {
            this.consumersOnNetwork.remove(id);
            this.markNetworkDirty(id);
        }
    }

    public void markNetworkDirty(NetworkId id) {
        if (!this.networkVersions.containsKey(id)) {
            this.networkVersions.put(id, new VersionNumber(1));
        }
        this.networkVersions.get(id).inc();
    }

    public int getNetworkVersion(NetworkId id) {
        if (!this.networkVersions.containsKey(id)) {
            return 0;
        }
        return this.networkVersions.get(id).getVersion();
    }

    @Nullable
    public BlockPos getConsumerPosition(@Nonnull ConsumerId consumer) {
        if (!this.consumerPositions.containsKey(consumer)) {
            this.consumerPositions.put(consumer, null);
            for (ChunkBlob blob : this.chunkBlobMap.values()) {
                IntPos intPos = blob.getConsumerPosition(consumer);
                if (intPos == null) continue;
                this.consumerPositions.put(consumer, blob.getPosition(intPos));
                break;
            }
        }
        return this.consumerPositions.get(consumer);
    }

    public void createNetworkProvider(BlockPos pos, ColorId color, NetworkId network) {
        this.providerPositions.remove(network);
        ChunkBlob blob = this.getOrCreateBlob(pos);
        blob.createNetworkProvider(pos, color, network);
        this.recalculateNetwork(blob);
    }

    public void createNetworkConsumer(BlockPos pos, ColorId color, ConsumerId consumer) {
        ChunkBlob blob = this.getOrCreateBlob(pos);
        blob.createNetworkConsumer(pos, color, consumer);
        this.recalculateNetwork(blob);
        this.consumerPositions.remove(consumer);
    }

    public void createCableSegment(BlockPos pos, ColorId color) {
        ChunkBlob blob = this.getOrCreateBlob(pos);
        blob.createCableSegment(pos, color);
        this.recalculateNetwork(blob);
    }

    @Nonnull
    private ChunkBlob getOrCreateBlob(BlockPos pos) {
        ChunkPos cpos = new ChunkPos(pos);
        long chunkId = ChunkPos.func_77272_a((int)cpos.field_77276_a, (int)cpos.field_77275_b);
        if (!this.chunkBlobMap.containsKey(chunkId)) {
            this.chunkBlobMap.put(chunkId, new ChunkBlob(cpos));
        }
        return this.chunkBlobMap.get(chunkId);
    }

    @Nullable
    private ChunkBlob getBlob(BlockPos pos) {
        ChunkPos cpos = new ChunkPos(pos);
        long chunkId = ChunkPos.func_77272_a((int)cpos.field_77276_a, (int)cpos.field_77275_b);
        return this.chunkBlobMap.get(chunkId);
    }

    public void removeCableSegment(BlockPos pos) {
        NetworkId providerId;
        ConsumerId consumerId = this.getConsumerAt(pos);
        if (consumerId != null) {
            this.consumerPositions.remove(consumerId);
        }
        if ((providerId = this.getNetworkAt(pos)) != null) {
            this.providerPositions.remove(providerId);
        }
        ChunkBlob blob = this.getOrCreateBlob(pos);
        blob.removeCableSegment(pos);
        this.recalculateNetwork();
    }

    public void recalculateNetwork(ChunkBlob blob) {
        this.removeCachedNetworksForBlob(blob);
        blob.fixNetworkAllocations();
        this.removeCachedNetworksForBlob(blob);
        HashSet<ChunkBlob> todo = new HashSet<ChunkBlob>();
        HashSet<ChunkBlob> recalculated = new HashSet<ChunkBlob>();
        recalculated.add(blob);
        todo.add(blob);
        this.recalculateNetwork(todo, recalculated);
    }

    public void recalculateNetwork() {
        for (ChunkBlob blob : this.chunkBlobMap.values()) {
            blob.fixNetworkAllocations();
            this.removeCachedNetworksForBlob(blob);
        }
        HashSet<ChunkBlob> todo = new HashSet<ChunkBlob>(this.chunkBlobMap.values());
        this.recalculateNetwork(todo, null);
    }

    private void recalculateNetwork(@Nonnull Set<ChunkBlob> todo, @Nullable Set<ChunkBlob> recalculated) {
        while (!todo.isEmpty()) {
            ChunkBlob blob = todo.iterator().next();
            todo.remove(blob);
            if (recalculated != null && !recalculated.contains(blob)) {
                blob.fixNetworkAllocations();
                recalculated.add(blob);
            }
            blob.clearNetworkCache();
            this.removeCachedNetworksForBlob(blob);
            Set<IntPos> borderPositions = blob.getBorderPositions();
            ChunkPos chunkPos = blob.getChunkPos();
            for (IntPos pos : borderPositions) {
                Set<NetworkId> networks = blob.getOrCreateNetworksForPosition(pos);
                ColorId color = blob.getColorIdForPosition(pos);
                for (Direction facing : OrientationTools.HORIZONTAL_DIRECTION_VALUES) {
                    Vector3i vec;
                    ChunkBlob adjacent;
                    if (!pos.isBorder(facing) || (adjacent = this.chunkBlobMap.get(ChunkPos.func_77272_a((int)(chunkPos.field_77276_a + (vec = facing.func_176730_m()).func_177958_n()), (int)(chunkPos.field_77275_b + vec.func_177952_p())))) == null) continue;
                    IntPos connectedPos = pos.otherSide(facing);
                    if (!adjacent.getBorderPositions().contains(connectedPos) || !adjacent.getColorIdForPosition(connectedPos).equals(color)) continue;
                    Set<NetworkId> adjacentNetworks = adjacent.getOrCreateNetworksForPosition(connectedPos);
                    if (networks.addAll(adjacentNetworks)) {
                        todo.add(blob);
                    }
                    if (!adjacentNetworks.addAll(networks)) continue;
                    todo.add(adjacent);
                }
            }
        }
    }

    public void checkNetwork(World world) {
        for (Map.Entry<Long, ChunkBlob> entry : this.chunkBlobMap.entrySet()) {
            entry.getValue().check(world);
        }
    }

    private void dump(String prefix, Set<NetworkId> networks) {
        String s = prefix + ": ";
        for (NetworkId network : networks) {
            s = s + network.getId() + " ";
        }
        System.out.println("s = " + s);
    }

    public void dump() {
        for (ChunkBlob blob : this.chunkBlobMap.values()) {
            blob.dump();
        }
    }

    public void readFromNBT(CompoundNBT compound) {
        this.chunkBlobMap.clear();
        this.lastNetworkId = compound.func_74762_e("lastNetwork");
        this.lastConsumerId = compound.func_74762_e("lastConsumer");
        if (compound.func_74764_b("chunks")) {
            ListNBT chunks = (ListNBT)compound.func_74781_a("chunks");
            for (INBT chunk : chunks) {
                CompoundNBT tc = (CompoundNBT)chunk;
                int chunkX = tc.func_74762_e("chunkX");
                int chunkZ = tc.func_74762_e("chunkZ");
                ChunkBlob blob = new ChunkBlob(new ChunkPos(chunkX, chunkZ));
                blob.readFromNBT(tc);
                this.chunkBlobMap.put(blob.getChunkNum(), blob);
            }
        }
    }

    public CompoundNBT writeToNBT(CompoundNBT compound) {
        compound.func_74768_a("lastNetwork", this.lastNetworkId);
        compound.func_74768_a("lastConsumer", this.lastConsumerId);
        ListNBT list = new ListNBT();
        for (Map.Entry<Long, ChunkBlob> entry : this.chunkBlobMap.entrySet()) {
            ChunkBlob blob = entry.getValue();
            CompoundNBT tc = new CompoundNBT();
            tc.func_74768_a("chunkX", blob.getChunkPos().field_77276_a);
            tc.func_74768_a("chunkZ", blob.getChunkPos().field_77275_b);
            blob.writeToNBT(tc);
            list.add((Object)tc);
        }
        compound.func_218657_a("chunks", (INBT)list);
        return compound;
    }
}

