/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import com.google.common.base.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.block.FridgeBlock;
import net.blay09.mods.cookingforblockheads.block.MilkJarBlock;
import net.blay09.mods.cookingforblockheads.block.OvenBlock;
import net.blay09.mods.cookingforblockheads.block.SinkBlock;
import net.blay09.mods.cookingforblockheads.block.ToasterBlock;
import net.blay09.mods.cookingforblockheads.tile.FridgeTileEntity;
import net.blay09.mods.cookingforblockheads.tile.MilkJarTileEntity;
import net.blay09.mods.cookingforblockheads.tile.OvenTileEntity;
import net.blay09.mods.cookingforblockheads.tile.SinkTileEntity;
import net.blay09.mods.cookingforblockheads.tile.ToasterTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.InterModComms;

public class TheOneProbeAddon {
    public static void register() {
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TopInitializer::new);
    }

    @Nullable
    private static <T extends TileEntity> T tryGetTileEntity(World world, BlockPos pos, Class<T> tileClass) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileClass.isAssignableFrom(tileEntity.getClass())) {
            return (T)tileEntity;
        }
        return null;
    }

    public static class ProbeInfoProvider
    implements IProbeInfoProvider {
        public String getID() {
            return "cookingforblockheads";
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo info, PlayerEntity playerEntity, World world, BlockState state, IProbeHitData data) {
            SinkTileEntity tileEntity;
            if (state.func_177230_c() instanceof MilkJarBlock) {
                MilkJarTileEntity tileEntity2 = (MilkJarTileEntity)TheOneProbeAddon.tryGetTileEntity(world, data.getPos(), MilkJarTileEntity.class);
                if (tileEntity2 != null) {
                    this.addMilkJarInfo(tileEntity2, info);
                }
            } else if (state.func_177230_c() instanceof ToasterBlock) {
                ToasterTileEntity tileEntity3 = (ToasterTileEntity)TheOneProbeAddon.tryGetTileEntity(world, data.getPos(), ToasterTileEntity.class);
                if (tileEntity3 != null) {
                    this.addToasterInfo(tileEntity3, info);
                }
            } else if (state.func_177230_c() instanceof OvenBlock) {
                OvenTileEntity tileEntity4 = (OvenTileEntity)TheOneProbeAddon.tryGetTileEntity(world, data.getPos(), OvenTileEntity.class);
                if (tileEntity4 != null && tileEntity4.hasPowerUpgrade()) {
                    info.text((ITextComponent)new TranslationTextComponent("waila.cookingforblockheads:heating_unit"));
                }
            } else if (state.func_177230_c() instanceof FridgeBlock) {
                FridgeTileEntity tileEntity5 = (FridgeTileEntity)TheOneProbeAddon.tryGetTileEntity(world, data.getPos(), FridgeTileEntity.class);
                if (tileEntity5 != null && tileEntity5.getBaseFridge().hasIceUpgrade()) {
                    info.text((ITextComponent)new TranslationTextComponent("waila.cookingforblockheads:ice_unit"));
                }
                if (tileEntity5 != null && tileEntity5.getBaseFridge().hasPreservationUpgrade()) {
                    info.text((ITextComponent)new TranslationTextComponent("waila.cookingforblockheads:preservation_chamber"));
                }
            } else if (state.func_177230_c() instanceof SinkBlock && (tileEntity = (SinkTileEntity)TheOneProbeAddon.tryGetTileEntity(world, data.getPos(), SinkTileEntity.class)) != null && ((Boolean)CookingForBlockheadsConfig.COMMON.sinkRequiresWater.get()).booleanValue()) {
                info.text((ITextComponent)new TranslationTextComponent("waila.cookingforblockheads:water_stored", new Object[]{tileEntity.getWaterAmount(), tileEntity.getWaterCapacity()}));
            }
        }

        private void addMilkJarInfo(MilkJarTileEntity tileEntity, IProbeInfo info) {
            info.text((ITextComponent)new TranslationTextComponent("waila.cookingforblockheads:milk_stored", new Object[]{(int)tileEntity.getMilkAmount(), (int)tileEntity.getMilkCapacity()}));
        }

        private void addToasterInfo(ToasterTileEntity tileEntity, IProbeInfo info) {
            if (tileEntity.isActive()) {
                info.text((ITextComponent)new TranslationTextComponent("waila.cookingforblockheads:toast_progress", new Object[]{(int)(tileEntity.getToastProgress() * 100.0f)}));
                info.progress((int)(tileEntity.getToastProgress() * 100.0f), 100);
            }
        }
    }

    public static class TopInitializer
    implements Function<ITheOneProbe, Void> {
        @Nullable
        public Void apply(@Nullable ITheOneProbe top) {
            if (top != null) {
                top.registerProvider((IProbeInfoProvider)new ProbeInfoProvider());
            }
            return null;
        }
    }
}

