/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.block.FridgeBlock;
import net.blay09.mods.cookingforblockheads.block.MilkJarBlock;
import net.blay09.mods.cookingforblockheads.block.OvenBlock;
import net.blay09.mods.cookingforblockheads.block.SinkBlock;
import net.blay09.mods.cookingforblockheads.block.ToasterBlock;
import net.blay09.mods.cookingforblockheads.tile.CowJarTileEntity;
import net.blay09.mods.cookingforblockheads.tile.FridgeTileEntity;
import net.blay09.mods.cookingforblockheads.tile.MilkJarTileEntity;
import net.blay09.mods.cookingforblockheads.tile.OvenTileEntity;
import net.blay09.mods.cookingforblockheads.tile.SinkTileEntity;
import net.blay09.mods.cookingforblockheads.tile.ToasterTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

@WailaPlugin(value="cookingforblockheads")
public class WailaAddon
implements IWailaPlugin {
    public void register(IRegistrar registrar) {
        registrar.registerComponentProvider((IComponentProvider)new MilkJarDataProvider(), TooltipPosition.HEAD, MilkJarBlock.class);
        registrar.registerComponentProvider((IComponentProvider)new MilkJarDataProvider(), TooltipPosition.BODY, MilkJarBlock.class);
        registrar.registerComponentProvider((IComponentProvider)new ToasterDataProvider(), TooltipPosition.BODY, ToasterBlock.class);
        registrar.registerComponentProvider((IComponentProvider)new OvenDataProvider(), TooltipPosition.BODY, OvenBlock.class);
        registrar.registerComponentProvider((IComponentProvider)new FridgeDataProvider(), TooltipPosition.BODY, FridgeBlock.class);
        registrar.registerComponentProvider((IComponentProvider)new SinkDataProvider(), TooltipPosition.BODY, SinkBlock.class);
    }

    public static class SinkDataProvider
    implements IComponentProvider {
        public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
            TileEntity tileEntity = accessor.getTileEntity();
            if (tileEntity instanceof SinkTileEntity && ((Boolean)CookingForBlockheadsConfig.COMMON.sinkRequiresWater.get()).booleanValue()) {
                SinkTileEntity sink = (SinkTileEntity)tileEntity;
                tooltip.add((ITextComponent)new TranslationTextComponent("waila.cookingforblockheads:water_stored", new Object[]{sink.getWaterAmount(), sink.getWaterCapacity()}));
            }
        }
    }

    public static class FridgeDataProvider
    implements IComponentProvider {
        public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
            TileEntity tileEntity = accessor.getTileEntity();
            if (tileEntity instanceof FridgeTileEntity) {
                FridgeTileEntity tileFridge = (FridgeTileEntity)tileEntity;
                if (tileFridge.hasIceUpgrade()) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("waila.cookingforblockheads:ice_unit"));
                }
                if (tileFridge.hasPreservationUpgrade()) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("waila.cookingforblockheads:preservation_chamber"));
                }
            }
        }
    }

    public static class OvenDataProvider
    implements IComponentProvider {
        public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
            OvenTileEntity tileOven;
            TileEntity tileEntity = accessor.getTileEntity();
            if (tileEntity instanceof OvenTileEntity && (tileOven = (OvenTileEntity)tileEntity).hasPowerUpgrade()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("waila.cookingforblockheads:heating_unit"));
            }
        }
    }

    public static class ToasterDataProvider
    implements IComponentProvider {
        public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
            ToasterTileEntity tileToaster;
            TileEntity tileEntity = accessor.getTileEntity();
            if (tileEntity instanceof ToasterTileEntity && (tileToaster = (ToasterTileEntity)tileEntity).isActive()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("waila.cookingforblockheads:toast_progress", new Object[]{(int)(tileToaster.getToastProgress() * 100.0f)}));
            }
        }
    }

    public static class MilkJarDataProvider
    implements IComponentProvider {
        public void appendHead(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
            TileEntity tileEntity = accessor.getTileEntity();
            if (tileEntity instanceof CowJarTileEntity && ((CowJarTileEntity)tileEntity).func_200201_e() != null) {
                tooltip.clear();
                tooltip.add(((CowJarTileEntity)tileEntity).func_200201_e());
            }
        }

        public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
            TileEntity tileEntity = accessor.getTileEntity();
            if (tileEntity instanceof MilkJarTileEntity) {
                MilkJarTileEntity tileMilkJar = (MilkJarTileEntity)tileEntity;
                tooltip.add((ITextComponent)new TranslationTextComponent("waila.cookingforblockheads:milk_stored", new Object[]{(int)tileMilkJar.getMilkAmount(), (int)tileMilkJar.getMilkCapacity()}));
            }
        }
    }
}

