/*
 * Decompiled with CFR 0.152.
 */
package com.mcwlights.kikoz.objects;

import com.mcwlights.kikoz.objects.LightBaseShort;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class WallLamp
extends LightBaseShort {
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final EnumProperty<DyeColor> DYE_COLOR = EnumProperty.func_177709_a((String)"dye_color", DyeColor.class);
    private static final VoxelShape NORTH = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST = Block.func_208617_a((double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape SOUTH = Block.func_208617_a((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape WEST = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);

    public WallLamp(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true))).func_206870_a(DYE_COLOR, (Comparable)DyeColor.WHITE));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        switch (direction) {
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
        }
        return VoxelShapes.func_197880_a();
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        DyeColor dyeColor = this.getDyeColor(context.func_195996_i());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a(DYE_COLOR, (Comparable)dyeColor);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT, FACING, DYE_COLOR});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(handIn);
        Item item = heldItem.func_77973_b();
        if (item instanceof DyeItem) {
            DyeColor dyeColor = ((DyeItem)item).func_195962_g();
            BlockState newState = (BlockState)state.func_206870_a(DYE_COLOR, (Comparable)dyeColor);
            worldIn.func_175656_a(pos, newState);
            if (!player.func_184812_l_()) {
                heldItem.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        if (item != this.func_199767_j()) {
            state = (BlockState)state.func_235896_a_((Property)LIT);
            worldIn.func_180501_a(pos, state, 10);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.8f);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private DyeColor getDyeColor(ItemStack stack) {
        if (stack.func_77973_b() instanceof DyeItem) {
            return ((DyeItem)stack.func_77973_b()).func_195962_g();
        }
        return DyeColor.WHITE;
    }
}

