/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.advancements.place_structure;

import com.google.gson.JsonObject;
import com.ldtteam.structurize.management.StructureName;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class PlaceStructureCriterionInstance
extends CriterionInstance {
    private String hutName;
    private StructureName structureName;

    public PlaceStructureCriterionInstance() {
        super(new ResourceLocation("minecolonies", "structure_placed"), EntityPredicate.AndPredicate.field_234582_a_);
    }

    public PlaceStructureCriterionInstance(String hutName) {
        super(new ResourceLocation("minecolonies", "structure_placed"), EntityPredicate.AndPredicate.field_234582_a_);
        this.hutName = hutName;
    }

    public PlaceStructureCriterionInstance(StructureName structureName) {
        super(new ResourceLocation("minecolonies", "structure_placed"), EntityPredicate.AndPredicate.field_234582_a_);
        this.structureName = structureName;
    }

    public boolean test(StructureName structureName) {
        if (this.hutName != null) {
            return this.hutName.equalsIgnoreCase(structureName.getHutName());
        }
        if (this.structureName != null) {
            return this.structureName.equals(structureName);
        }
        return true;
    }

    @NotNull
    public static PlaceStructureCriterionInstance deserializeFromJson(@NotNull JsonObject jsonObject, @NotNull ConditionArrayParser conditions) {
        if (jsonObject.has("hut_name")) {
            String hutName = JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"hut_name");
            return new PlaceStructureCriterionInstance(hutName);
        }
        if (jsonObject.has("structure_name")) {
            StructureName structureName = new StructureName(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"structure_name"));
            return new PlaceStructureCriterionInstance(structureName);
        }
        return new PlaceStructureCriterionInstance();
    }

    @NotNull
    public JsonObject func_230240_a_(@NotNull ConditionArraySerializer serializer) {
        JsonObject json = super.func_230240_a_(serializer);
        if (this.hutName != null) {
            json.addProperty("hut_name", this.hutName);
        } else if (this.structureName != null) {
            json.addProperty("structure_name", this.structureName.toString());
        }
        return json;
    }
}

