/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public interface IColonyTagCapability {
    public void removeColony(int var1, Chunk var2);

    public void addColony(int var1, Chunk var2);

    @NotNull
    public List<Integer> getStaticClaimColonies();

    public void setOwningColony(int var1, Chunk var2);

    public int getOwningColony();

    public void reset(Chunk var1);

    public void addBuildingClaim(int var1, BlockPos var2, Chunk var3);

    public void removeBuildingClaim(int var1, BlockPos var2, Chunk var3);

    public void setCloseColonies(List<Integer> var1);

    @NotNull
    public Map<Integer, Set<BlockPos>> getAllClaimingBuildings();

    public void readFromNBT(CompoundNBT var1);

    public static class Storage
    implements Capability.IStorage<IColonyTagCapability> {
        public INBT writeNBT(@NotNull Capability<IColonyTagCapability> capability, @NotNull IColonyTagCapability instance, @Nullable Direction side) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74768_a("id", instance.getOwningColony());
            compound.func_218657_a("colonies", (INBT)instance.getStaticClaimColonies().stream().map(Storage::write).collect(NBTUtils.toListNBT()));
            compound.func_218657_a("buildingsClaim", (INBT)instance.getAllClaimingBuildings().entrySet().stream().map(Storage::writeClaims).collect(NBTUtils.toListNBT()));
            return compound;
        }

        public void readNBT(@NotNull Capability<IColonyTagCapability> capability, @NotNull IColonyTagCapability instance, @Nullable Direction side, @NotNull INBT nbt) {
            if (nbt instanceof CompoundNBT && ((CompoundNBT)nbt).func_74764_b("id")) {
                instance.readFromNBT((CompoundNBT)nbt);
            }
        }

        private static CompoundNBT write(int id) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74768_a("id", id);
            return compound;
        }

        private static CompoundNBT writeClaims(@NotNull Map.Entry<Integer, Set<BlockPos>> entry) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74768_a("id", entry.getKey().intValue());
            compound.func_218657_a("buildings", (INBT)entry.getValue().stream().map(pos -> BlockPosUtil.write(new CompoundNBT(), "building", pos)).collect(NBTUtils.toListNBT()));
            return compound;
        }
    }

    public static class Impl
    implements IColonyTagCapability {
        private Set<Integer> colonies = new HashSet<Integer>();
        private int owningColony = 0;
        private final Map<Integer, Set<BlockPos>> claimingBuildings = new HashMap<Integer, Set<BlockPos>>();

        @Override
        public void addColony(int id, Chunk chunk) {
            IColony colony = IColonyManager.getInstance().getColonyByDimension(id, (RegistryKey<World>)chunk.func_177412_p().func_234923_W_());
            if (colony == null) {
                return;
            }
            this.colonies.add(id);
            if (this.owningColony == 0 || IColonyManager.getInstance().getColonyByDimension(this.owningColony, (RegistryKey<World>)chunk.func_177412_p().func_234923_W_()) == null) {
                colony.addLoadedChunk(ChunkPos.func_77272_a((int)chunk.func_76632_l().field_77276_a, (int)chunk.func_76632_l().field_77275_b), chunk);
                this.owningColony = id;
            }
            chunk.func_76630_e();
        }

        @Override
        public void removeColony(int id, Chunk chunk) {
            this.colonies.remove(id);
            this.claimingBuildings.remove(id);
            if (this.owningColony == id) {
                this.owningColony = !this.claimingBuildings.isEmpty() ? this.claimingBuildings.keySet().iterator().next() : (!this.colonies.isEmpty() ? this.colonies.iterator().next() : 0);
            }
            chunk.func_76630_e();
        }

        @Override
        public void setCloseColonies(List<Integer> colonies) {
            this.colonies = new HashSet<Integer>(colonies);
        }

        @Override
        public void reset(Chunk chunk) {
            this.colonies.clear();
            this.owningColony = 0;
            this.claimingBuildings.clear();
            chunk.func_76630_e();
        }

        @Override
        public void addBuildingClaim(int colonyId, BlockPos pos, Chunk chunk) {
            if (this.owningColony == 0) {
                this.setOwningColony(colonyId, chunk);
                IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyId, (RegistryKey<World>)chunk.func_177412_p().func_234923_W_());
                if (colony != null) {
                    colony.addLoadedChunk(ChunkPos.func_77272_a((int)chunk.func_76632_l().field_77276_a, (int)chunk.func_76632_l().field_77275_b), chunk);
                }
            }
            if (this.claimingBuildings.containsKey(colonyId)) {
                this.claimingBuildings.get(colonyId).add(pos);
            } else {
                HashSet<BlockPos> newList = new HashSet<BlockPos>();
                newList.add(pos);
                this.claimingBuildings.put(colonyId, newList);
            }
            chunk.func_76630_e();
        }

        @Override
        public void removeBuildingClaim(int colonyId, BlockPos pos, Chunk chunk) {
            if (!this.claimingBuildings.containsKey(colonyId)) {
                return;
            }
            chunk.func_177427_f(true);
            Set<BlockPos> buildings = this.claimingBuildings.get(colonyId);
            buildings.remove(pos);
            if (buildings.isEmpty()) {
                this.claimingBuildings.remove(colonyId);
                if (this.owningColony == colonyId && !this.colonies.contains(this.owningColony)) {
                    if (this.claimingBuildings.isEmpty()) {
                        this.owningColony = this.colonies.isEmpty() ? 0 : this.colonies.iterator().next();
                    } else {
                        Iterator<Map.Entry<Integer, Set<BlockPos>>> colonyIt = this.claimingBuildings.entrySet().iterator();
                        while (colonyIt.hasNext()) {
                            Map.Entry<Integer, Set<BlockPos>> colonyEntry = colonyIt.next();
                            IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyEntry.getKey(), (RegistryKey<World>)chunk.func_177412_p().func_234923_W_());
                            if (colony == null) continue;
                            Iterator<BlockPos> buildingIt = colonyEntry.getValue().iterator();
                            while (buildingIt.hasNext()) {
                                BlockPos buildingPos = buildingIt.next();
                                if (colony.getBuildingManager().getBuilding(buildingPos) != null) {
                                    colony.addLoadedChunk(ChunkPos.func_77272_a((int)chunk.func_76632_l().field_77276_a, (int)chunk.func_76632_l().field_77275_b), chunk);
                                    this.setOwningColony(colonyEntry.getKey(), chunk);
                                    return;
                                }
                                buildingIt.remove();
                            }
                            if (!colonyEntry.getValue().isEmpty()) continue;
                            colonyIt.remove();
                        }
                    }
                }
            }
        }

        @Override
        public void setOwningColony(int id, Chunk chunk) {
            this.owningColony = id;
            chunk.func_76630_e();
        }

        @Override
        public int getOwningColony() {
            return this.owningColony;
        }

        @Override
        @NotNull
        public List<Integer> getStaticClaimColonies() {
            return new ArrayList<Integer>(this.colonies);
        }

        @Override
        @NotNull
        public Map<Integer, Set<BlockPos>> getAllClaimingBuildings() {
            return this.claimingBuildings;
        }

        @Override
        public void readFromNBT(CompoundNBT compound) {
            this.owningColony = compound.func_74762_e("id");
            NBTUtils.streamCompound(compound.func_150295_c("colonies", 10)).map(c -> c.func_74762_e("id")).forEach(this.colonies::add);
            NBTUtils.streamCompound(compound.func_150295_c("buildingsClaim", 10)).forEach(this::readClaims);
        }

        private void readClaims(CompoundNBT compound) {
            int id = compound.func_74762_e("id");
            NBTUtils.streamCompound(compound.func_150295_c("buildings", 10)).forEach(tag -> {
                BlockPos pos = BlockPosUtil.read(tag, "building");
                if (this.claimingBuildings.containsKey(id)) {
                    this.claimingBuildings.get(id).add(pos);
                } else {
                    HashSet<BlockPos> newList = new HashSet<BlockPos>();
                    newList.add(pos);
                    this.claimingBuildings.put(id, newList);
                }
            });
        }
    }
}

