/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.configuration;

import com.minecolonies.api.configuration.ClientConfiguration;
import com.minecolonies.api.configuration.CommonConfiguration;
import com.minecolonies.api.configuration.ServerConfiguration;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class Configuration {
    private final ClientConfiguration clientConfig;
    private final ServerConfiguration serverConfig;
    private final CommonConfiguration commonConfiguration;

    public Configuration() {
        Pair cli = new ForgeConfigSpec.Builder().configure(ClientConfiguration::new);
        Pair ser = new ForgeConfigSpec.Builder().configure(ServerConfiguration::new);
        Pair com = new ForgeConfigSpec.Builder().configure(CommonConfiguration::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (ForgeConfigSpec)cli.getRight());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (ForgeConfigSpec)ser.getRight());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (ForgeConfigSpec)com.getRight());
        this.clientConfig = (ClientConfiguration)cli.getLeft();
        this.serverConfig = (ServerConfiguration)ser.getLeft();
        this.commonConfiguration = (CommonConfiguration)com.getLeft();
    }

    public ClientConfiguration getClient() {
        return this.clientConfig;
    }

    public ServerConfiguration getServer() {
        return this.serverConfig;
    }

    public CommonConfiguration getCommon() {
        return this.commonConfiguration;
    }
}

