/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.profiler.IProfiler;
import org.jetbrains.annotations.NotNull;

public class CustomGoalSelector
extends GoalSelector {
    private static final PrioritizedGoal DUMMY = new PrioritizedGoal(Integer.MAX_VALUE, new Goal(){

        public boolean func_75250_a() {
            return false;
        }
    }){

        public boolean func_220773_g() {
            return false;
        }
    };
    private final PrioritizedGoal[] flagGoalsArray = new PrioritizedGoal[FLAG_COUNT];
    public Set<PrioritizedGoal> field_220892_d = Sets.newHashSet();
    private Supplier<IProfiler> profiler;
    private final boolean[] disabledFlagsArray = new boolean[FLAG_COUNT];
    private static final int FLAG_COUNT = Goal.Flag.values().length;
    int counter = 0;

    public CustomGoalSelector(@NotNull GoalSelector old) {
        super(old.field_75781_c);
        this.importFrom(old);
        ((GoalSelector)this).field_220892_d = this.field_220892_d;
        this.field_75781_c = this.profiler;
    }

    public CustomGoalSelector(@NotNull Supplier<IProfiler> profiler) {
        super(profiler);
        this.profiler = profiler;
        ((GoalSelector)this).field_220892_d = this.field_220892_d;
        this.field_75781_c = this.profiler;
        for (Goal.Flag flag : Goal.Flag.values()) {
            this.flagGoalsArray[flag.ordinal()] = DUMMY;
        }
    }

    public void importFrom(GoalSelector selector) {
        if (selector == null) {
            return;
        }
        for (Goal.Flag flag : Goal.Flag.values()) {
            this.flagGoalsArray[flag.ordinal()] = selector.field_220891_c.getOrDefault(flag, DUMMY);
        }
        this.field_220892_d = selector.field_220892_d;
        this.profiler = selector.field_75781_c;
        for (Goal.Flag flag : selector.field_220893_f) {
            this.disabledFlagsArray[flag.ordinal()] = true;
        }
    }

    public void func_75776_a(int priority, Goal task) {
        this.field_220892_d.add(new PrioritizedGoal(priority, task));
    }

    public void func_85156_a(Goal task) {
        for (PrioritizedGoal prioritizedGoal : new ArrayList<PrioritizedGoal>(this.field_220892_d)) {
            if (prioritizedGoal.func_220772_j() != task) continue;
            prioritizedGoal.func_75251_c();
            this.field_220892_d.remove(prioritizedGoal);
        }
    }

    private boolean goalContainsDisabledFlag(PrioritizedGoal goal) {
        for (int i = 0; i < FLAG_COUNT; ++i) {
            if (!this.disabledFlagsArray[i] || !goal.func_220686_i().contains(Goal.Flag.values()[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isPreemptedByAll(PrioritizedGoal goal1) {
        for (int i = 0; i < FLAG_COUNT; ++i) {
            PrioritizedGoal compareGoal = this.flagGoalsArray[i];
            if (!compareGoal.func_220773_g() || compareGoal.func_220771_a(goal1) || !goal1.func_220686_i().contains(Goal.Flag.values()[i])) continue;
            return false;
        }
        return true;
    }

    public void func_75774_a() {
        this.profiler.get().func_76320_a("goalUpdate");
        ++this.counter;
        for (PrioritizedGoal currentGoal : new ArrayList<PrioritizedGoal>(this.field_220892_d)) {
            boolean hasFlags;
            boolean bl = hasFlags = !currentGoal.func_220686_i().isEmpty();
            if (currentGoal.func_220773_g() && (hasFlags && this.goalContainsDisabledFlag(currentGoal) || !currentGoal.func_75253_b())) {
                currentGoal.func_75251_c();
            }
            if (this.counter == 1 && !currentGoal.func_220773_g() && (!hasFlags && currentGoal.func_75250_a() || !this.goalContainsDisabledFlag(currentGoal) && this.isPreemptedByAll(currentGoal) && currentGoal.func_75250_a())) {
                for (Goal.Flag flag : currentGoal.func_220686_i()) {
                    PrioritizedGoal prioritizedgoal = this.flagGoalsArray[flag.ordinal()];
                    prioritizedgoal.func_75251_c();
                    this.flagGoalsArray[flag.ordinal()] = currentGoal;
                }
                currentGoal.func_75249_e();
            }
            if (!currentGoal.func_220773_g()) continue;
            currentGoal.func_75246_d();
        }
        if (this.counter > 3) {
            this.counter = 0;
        }
        this.profiler.get().func_76319_b();
    }

    public Stream<PrioritizedGoal> func_220888_c() {
        return this.field_220892_d.stream().filter(PrioritizedGoal::func_220773_g);
    }

    public void func_220880_a(Goal.Flag flag) {
        this.disabledFlagsArray[flag.ordinal()] = true;
    }

    public void func_220886_b(Goal.Flag flag) {
        this.disabledFlagsArray[flag.ordinal()] = false;
    }

    public void func_220878_a(Goal.Flag flag, boolean enabled) {
        if (enabled) {
            this.func_220886_b(flag);
        } else {
            this.func_220880_a(flag);
        }
    }
}

