/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ReuseableStream;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class MinecoloniesMinecart
extends AbstractMinecartEntity {
    private static final Map<RailShape, Pair<Vector3i, Vector3i>> MATRIX = (Map)Util.func_200696_a((Object)Maps.newEnumMap(RailShape.class), entry -> {
        Vector3i westVec = Direction.WEST.func_176730_m();
        Vector3i eastVec = Direction.EAST.func_176730_m();
        Vector3i northVec = Direction.NORTH.func_176730_m();
        Vector3i southVec = Direction.SOUTH.func_176730_m();
        entry.put(RailShape.NORTH_SOUTH, Pair.of((Object)northVec, (Object)southVec));
        entry.put(RailShape.EAST_WEST, Pair.of((Object)westVec, (Object)eastVec));
        entry.put(RailShape.ASCENDING_EAST, Pair.of((Object)westVec.func_177977_b(), (Object)eastVec));
        entry.put(RailShape.ASCENDING_WEST, Pair.of((Object)westVec, (Object)eastVec.func_177977_b()));
        entry.put(RailShape.ASCENDING_NORTH, Pair.of((Object)northVec, (Object)southVec.func_177977_b()));
        entry.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)northVec.func_177977_b(), (Object)southVec));
        entry.put(RailShape.SOUTH_EAST, Pair.of((Object)southVec, (Object)eastVec));
        entry.put(RailShape.SOUTH_WEST, Pair.of((Object)southVec, (Object)westVec));
        entry.put(RailShape.NORTH_WEST, Pair.of((Object)northVec, (Object)westVec));
        entry.put(RailShape.NORTH_EAST, Pair.of((Object)northVec, (Object)eastVec));
    });

    public MinecoloniesMinecart(EntityType<?> type, World world) {
        super(type, world);
    }

    protected void func_180460_a(BlockPos pos, BlockState state) {
        double tempVeloc;
        Vector3d tempMot;
        double xzDif;
        this.field_70143_R = 0.0f;
        double x = this.func_226277_ct_();
        double y = this.func_226278_cu_();
        double z = this.func_226281_cx_();
        Vector3d posVec = this.func_70489_a(x, y, z);
        y = pos.func_177956_o();
        boolean isPowered = false;
        boolean flag = false;
        AbstractRailBlock abstractrailblock = (AbstractRailBlock)state.func_177230_c();
        if (abstractrailblock instanceof PoweredRailBlock && !((PoweredRailBlock)abstractrailblock).isActivatorRail()) {
            isPowered = (Boolean)state.func_177229_b((Property)PoweredRailBlock.field_176569_M);
            flag = !isPowered;
        }
        RailShape railshape = ((AbstractRailBlock)state.func_177230_c()).getRailDirection(state, (IBlockReader)this.field_70170_p, pos, (AbstractMinecartEntity)this);
        switch (railshape) {
            case ASCENDING_EAST: 
            case ASCENDING_WEST: 
            case ASCENDING_NORTH: 
            case ASCENDING_SOUTH: {
                y += 1.0;
                break;
            }
        }
        Vector3d motion = this.func_213322_ci();
        Pair<Vector3i, Vector3i> pair = MinecoloniesMinecart.getShapeMatrix(railshape);
        Vector3i vecIn = (Vector3i)pair.getFirst();
        Vector3i vecOut = (Vector3i)pair.getSecond();
        double xDif = vecOut.func_177958_n() - vecIn.func_177958_n();
        double zDif = vecOut.func_177952_p() - vecIn.func_177952_p();
        double difSq = Math.sqrt(xDif * xDif + zDif * zDif);
        double difMotion = motion.field_72450_a * xDif + motion.field_72449_c * zDif;
        if (difMotion < 0.0) {
            xDif = -xDif;
            zDif = -zDif;
        }
        double veloc = Math.min(2.0, Math.sqrt(MinecoloniesMinecart.func_213296_b((Vector3d)motion)));
        motion = new Vector3d(veloc * xDif / difSq, motion.field_72448_b, veloc * zDif / difSq);
        this.func_213317_d(motion);
        if (flag && this.shouldDoRailFunctions()) {
            double tempMot2 = Math.sqrt(MinecoloniesMinecart.func_213296_b((Vector3d)this.func_213322_ci()));
            if (tempMot2 < 0.03) {
                this.func_213317_d(Vector3d.field_186680_a);
            } else {
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.5, 0.0, 0.5));
            }
        }
        double xInDif = (double)pos.func_177958_n() + 0.5 + (double)vecIn.func_177958_n() * 0.5;
        double zInDif = (double)pos.func_177952_p() + 0.5 + (double)vecIn.func_177952_p() * 0.5;
        double xOutDif = (double)pos.func_177958_n() + 0.5 + (double)vecOut.func_177958_n() * 0.5;
        double zOutDif = (double)pos.func_177952_p() + 0.5 + (double)vecOut.func_177952_p() * 0.5;
        xDif = xOutDif - xInDif;
        zDif = zOutDif - zInDif;
        if (xDif == 0.0) {
            xzDif = z - (double)pos.func_177952_p();
        } else if (zDif == 0.0) {
            xzDif = x - (double)pos.func_177958_n();
        } else {
            double d15 = x - xInDif;
            double d16 = z - zInDif;
            xzDif = (d15 * xDif + d16 * zDif) * 2.0;
        }
        x = xInDif + xDif * xzDif;
        z = zInDif + zDif * xzDif;
        this.func_70107_b(x, y, z);
        this.moveMinecartOnRail(pos);
        if (vecIn.func_177956_o() != 0 && MathHelper.func_76128_c((double)this.func_226277_ct_()) - pos.func_177958_n() == vecIn.func_177958_n() && MathHelper.func_76128_c((double)this.func_226281_cx_()) - pos.func_177952_p() == vecIn.func_177952_p()) {
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)vecIn.func_177956_o(), this.func_226281_cx_());
        } else if (vecOut.func_177956_o() != 0 && MathHelper.func_76128_c((double)this.func_226277_ct_()) - pos.func_177958_n() == vecOut.func_177958_n() && MathHelper.func_76128_c((double)this.func_226281_cx_()) - pos.func_177952_p() == vecOut.func_177952_p()) {
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)vecOut.func_177956_o(), this.func_226281_cx_());
        }
        this.func_94101_h();
        Vector3d newPos = this.func_70489_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        if (newPos != null && posVec != null) {
            double yMot = (posVec.field_72448_b - newPos.field_72448_b) * 0.05;
            tempMot = this.func_213322_ci();
            tempVeloc = Math.sqrt(MinecoloniesMinecart.func_213296_b((Vector3d)tempMot));
            if (tempVeloc > 0.0) {
                this.func_213317_d(tempMot.func_216372_d((tempVeloc + yMot) / tempVeloc, 1.0, (tempVeloc + yMot) / tempVeloc));
            }
            this.func_70107_b(this.func_226277_ct_(), newPos.field_72448_b, this.func_226281_cx_());
        }
        int xFloor = MathHelper.func_76128_c((double)this.func_226277_ct_());
        int zFloor = MathHelper.func_76128_c((double)this.func_226281_cx_());
        if (xFloor != pos.func_177958_n() || zFloor != pos.func_177952_p()) {
            tempMot = this.func_213322_ci();
            double temoVeloc = Math.sqrt(MinecoloniesMinecart.func_213296_b((Vector3d)tempMot));
            this.func_213293_j(temoVeloc * (double)(xFloor - pos.func_177958_n()), tempMot.field_72448_b, temoVeloc * (double)(zFloor - pos.func_177952_p()));
        }
        if (this.shouldDoRailFunctions()) {
            ((AbstractRailBlock)state.func_177230_c()).onMinecartPass(state, this.field_70170_p, pos, (AbstractMinecartEntity)this);
        }
        if (isPowered && this.shouldDoRailFunctions()) {
            tempMot = this.func_213322_ci();
            tempVeloc = Math.sqrt(MinecoloniesMinecart.func_213296_b((Vector3d)tempMot));
            if (tempVeloc > 0.01) {
                this.func_213317_d(tempMot.func_72441_c(tempMot.field_72450_a / tempVeloc * 0.06, 0.0, tempMot.field_72449_c / tempVeloc * 0.06));
            } else {
                Vector3d mot = this.func_213322_ci();
                double tempX = mot.field_72450_a;
                double tempZ = mot.field_72449_c;
                if (railshape == RailShape.EAST_WEST) {
                    if (this.isNormalCube(pos.func_177976_e())) {
                        tempX = 0.02;
                    } else if (this.isNormalCube(pos.func_177974_f())) {
                        tempX = -0.02;
                    }
                } else {
                    if (railshape != RailShape.NORTH_SOUTH) {
                        return;
                    }
                    if (this.isNormalCube(pos.func_177978_c())) {
                        tempZ = 0.02;
                    } else if (this.isNormalCube(pos.func_177968_d())) {
                        tempZ = -0.02;
                    }
                }
                this.func_213293_j(tempX, mot.field_72448_b, tempZ);
            }
        }
    }

    private boolean isNormalCube(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_215686_e((IBlockReader)this.field_70170_p, pos);
    }

    private static Pair<Vector3i, Vector3i> getShapeMatrix(RailShape p_226573_0_) {
        return MATRIX.get(p_226573_0_);
    }

    public ActionResultType func_184230_a(PlayerEntity p_184230_1_, Hand p_184230_2_) {
        return ActionResultType.FAIL;
    }

    public boolean func_70067_L() {
        return false;
    }

    @NotNull
    public AbstractMinecartEntity.Type func_184264_v() {
        return AbstractMinecartEntity.Type.RIDEABLE;
    }

    public void func_70108_f(@NotNull Entity entityIn) {
    }

    public void func_70100_b_(PlayerEntity entityIn) {
    }

    public boolean func_70104_M() {
        return false;
    }

    @NotNull
    public Vector3d func_213306_e(Vector3d vec) {
        boolean groundDif;
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        ISelectionContext iselectioncontext = ISelectionContext.func_216374_a((Entity)this);
        VoxelShape voxelshape = this.field_70170_p.func_175723_af().func_222521_a();
        Stream<Object> stream = VoxelShapes.func_197879_c((VoxelShape)voxelshape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)axisalignedbb.func_186664_h(1.0E-7)), (IBooleanFunction)IBooleanFunction.field_223238_i_) ? Stream.empty() : Stream.of(voxelshape);
        ReuseableStream reuseablestream = new ReuseableStream(stream);
        Vector3d vector3d = vec.func_189985_c() == 0.0 ? vec : MinecoloniesMinecart.func_223307_a((Entity)this, (Vector3d)vec, (AxisAlignedBB)axisalignedbb, (World)this.field_70170_p, (ISelectionContext)iselectioncontext, (ReuseableStream)reuseablestream);
        boolean xDif = vec.field_72450_a != vector3d.field_72450_a;
        boolean yDif = vec.field_72448_b != vector3d.field_72448_b;
        boolean zDif = vec.field_72449_c != vector3d.field_72449_c;
        boolean bl = groundDif = this.field_70122_E || yDif && vec.field_72448_b < 0.0;
        if (this.field_70138_W > 0.0f && groundDif && (xDif || zDif)) {
            Vector3d vector3d3;
            Vector3d vector3d1 = MinecoloniesMinecart.func_223307_a((Entity)this, (Vector3d)new Vector3d(vec.field_72450_a, (double)this.field_70138_W, vec.field_72449_c), (AxisAlignedBB)axisalignedbb, (World)this.field_70170_p, (ISelectionContext)iselectioncontext, (ReuseableStream)reuseablestream);
            Vector3d vector3d2 = MinecoloniesMinecart.func_223307_a((Entity)this, (Vector3d)new Vector3d(0.0, (double)this.field_70138_W, 0.0), (AxisAlignedBB)axisalignedbb.func_72321_a(vec.field_72450_a, 0.0, vec.field_72449_c), (World)this.field_70170_p, (ISelectionContext)iselectioncontext, (ReuseableStream)reuseablestream);
            if (vector3d2.field_72448_b < (double)this.field_70138_W && MinecoloniesMinecart.func_213296_b((Vector3d)(vector3d3 = MinecoloniesMinecart.func_223307_a((Entity)this, (Vector3d)new Vector3d(vec.field_72450_a, 0.0, vec.field_72449_c), (AxisAlignedBB)axisalignedbb.func_191194_a(vector3d2), (World)this.field_70170_p, (ISelectionContext)iselectioncontext, (ReuseableStream)reuseablestream).func_178787_e(vector3d2))) > MinecoloniesMinecart.func_213296_b((Vector3d)vector3d1)) {
                vector3d1 = vector3d3;
            }
            if (MinecoloniesMinecart.func_213296_b((Vector3d)vector3d1) > MinecoloniesMinecart.func_213296_b((Vector3d)vector3d)) {
                return vector3d1.func_178787_e(MinecoloniesMinecart.func_223307_a((Entity)this, (Vector3d)new Vector3d(0.0, -vector3d1.field_72448_b + vec.field_72448_b, 0.0), (AxisAlignedBB)axisalignedbb.func_191194_a(vector3d1), (World)this.field_70170_p, (ISelectionContext)iselectioncontext, (ReuseableStream)reuseablestream));
            }
        }
        return vector3d;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa % 20 == 19 && this.func_184188_bt().isEmpty()) {
            this.func_70106_y();
        }
    }

    @NotNull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

