/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity;

import com.minecolonies.api.entity.ICustomAttackSound;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.items.ModItems;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class SpearEntity
extends AbstractArrowEntity
implements ICustomAttackSound {
    private static final int MAX_TIME_ALIVE = 1200;
    public static final int BASE_DAMAGE = 8;
    public static final String NBT_WEAPON = "Weapon";
    public static final String NBT_DEALT_DAMAGE = "DealtDamage";
    protected ItemStack weapon = new ItemStack((IItemProvider)ModItems.spear);
    private boolean dealtDamage;

    public SpearEntity(EntityType<? extends AbstractArrowEntity> type, World world) {
        super(type, world);
        this.func_213297_N();
    }

    public SpearEntity(World world, LivingEntity thrower, ItemStack thrownWeapon) {
        super(ModEntities.SPEAR, thrower, world);
        this.weapon = thrownWeapon.func_77946_l();
        this.func_213297_N();
    }

    @NotNull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @NotNull
    public ItemStack func_184550_j() {
        return this.weapon.func_77946_l();
    }

    protected EntityRayTraceResult func_213866_a(@NotNull Vector3d startVec, @NotNull Vector3d endVec) {
        return this.dealtDamage ? null : super.func_213866_a(startVec, endVec);
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        Entity ownerEntity;
        Entity targetEntity = result.func_216348_a();
        float damageAmount = 8.0f;
        if (targetEntity instanceof LivingEntity) {
            damageAmount += EnchantmentHelper.func_152377_a((ItemStack)this.weapon, (CreatureAttribute)((LivingEntity)targetEntity).func_70668_bt());
        }
        DamageSource damageSource = new IndirectEntityDamageSource("spear", (Entity)this, (Entity)((ownerEntity = this.func_234616_v_()) == null ? this : ownerEntity)).func_76349_b();
        this.dealtDamage = true;
        if (targetEntity.func_70097_a(damageSource, damageAmount)) {
            if (targetEntity.func_200600_R() == EntityType.field_200803_q) {
                return;
            }
            if (targetEntity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)targetEntity;
                if (ownerEntity instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)livingEntity, (Entity)ownerEntity);
                    EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)ownerEntity), (Entity)livingEntity);
                }
                this.func_184548_a(livingEntity);
            }
        }
        this.func_213317_d(this.func_213322_ci().func_216372_d(-0.01, -0.1, -0.01));
        this.func_184185_a(SoundEvents.field_203268_ij, 1.0f, 1.0f);
    }

    @NotNull
    protected SoundEvent func_213867_k() {
        return SoundEvents.field_203269_ik;
    }

    public void func_70037_a(@NotNull CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_150297_b(NBT_WEAPON, 10)) {
            this.weapon = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l(NBT_WEAPON));
        }
        this.dealtDamage = nbt.func_74767_n(NBT_DEALT_DAMAGE);
    }

    public void func_213281_b(@NotNull CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_218657_a(NBT_WEAPON, (INBT)this.weapon.func_77955_b(new CompoundNBT()));
        nbt.func_74757_a(NBT_DEALT_DAMAGE, this.dealtDamage);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 1200) {
            this.func_70106_y();
        }
    }

    public void func_225516_i_() {
        if (this.field_70251_a != AbstractArrowEntity.PickupStatus.ALLOWED) {
            super.func_225516_i_();
        }
    }

    protected float func_203044_p() {
        return 0.9f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    @Override
    public SoundEvent getAttackSound() {
        return SoundEvents.field_203274_ip;
    }
}

