/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.container;

import com.minecolonies.api.inventory.ModContainers;
import com.minecolonies.api.util.ItemStackUtils;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ContainerCraftingBrewingstand
extends Container {
    private final IItemHandler brewingStandInventory;
    private final PlayerInventory playerInventory;
    public final BlockPos buildingPos;
    private String moduleId;

    public static ContainerCraftingBrewingstand fromFriendlyByteBuf(int windowId, PlayerInventory inv, PacketBuffer packetBuffer) {
        BlockPos tePos = packetBuffer.func_179259_c();
        String moduleId = packetBuffer.func_150789_c(Short.MAX_VALUE);
        return new ContainerCraftingBrewingstand(windowId, inv, tePos, moduleId);
    }

    public ContainerCraftingBrewingstand(int windowId, PlayerInventory inv, BlockPos pos, String moduleId) {
        super(ModContainers.craftingBrewingstand, windowId);
        int i;
        this.moduleId = moduleId;
        this.brewingStandInventory = new IItemHandlerModifiable(){
            ItemStack ingredient = ItemStack.field_190927_a;
            ItemStack potion = ItemStack.field_190927_a;

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                if (!this.isItemValid(slot, stack) && !ItemStackUtils.isEmpty(stack).booleanValue()) {
                    return;
                }
                ItemStack copy = stack.func_77946_l();
                copy.func_190920_e(1);
                if (slot == 3) {
                    this.ingredient = copy;
                } else {
                    this.potion = copy;
                }
            }

            public int getSlots() {
                return 4;
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                if (slot == 3) {
                    return this.ingredient;
                }
                return this.potion;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack) && !ItemStackUtils.isEmpty(stack).booleanValue()) {
                    return stack;
                }
                ItemStack copy = stack.func_77946_l();
                copy.func_190920_e(1);
                if (slot == 3) {
                    this.ingredient = copy;
                } else {
                    this.potion = copy;
                }
                return stack;
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.field_190927_a;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 3) {
                    return BrewingRecipeRegistry.isValidIngredient((ItemStack)stack);
                }
                if (slot >= 0 && slot < 3) {
                    return BrewingRecipeRegistry.isValidInput((ItemStack)stack);
                }
                return false;
            }
        };
        this.playerInventory = inv;
        this.buildingPos = pos;
        this.func_75146_a((Slot)new SlotItemHandler(this.brewingStandInventory, 3, 79, 17));
        this.func_75146_a((Slot)new InputItemHandler(this.brewingStandInventory, 0, 56, 51));
        this.func_75146_a((Slot)new InputItemHandler(this.brewingStandInventory, 1, 79, 58));
        this.func_75146_a((Slot)new InputItemHandler(this.brewingStandInventory, 2, 102, 51));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)this.playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.playerInventory, i, 8 + i * 18, 142));
        }
    }

    @NotNull
    public ItemStack func_184996_a(int slotId, int clickedButton, @NotNull ClickType mode, @NotNull PlayerEntity playerIn) {
        if (slotId >= 0 && slotId < this.brewingStandInventory.getSlots()) {
            if (mode == ClickType.PICKUP || mode == ClickType.PICKUP_ALL || mode == ClickType.SWAP || mode == ClickType.QUICK_MOVE) {
                Slot slot = (Slot)this.field_75151_b.get(slotId);
                return this.handleSlotClick(slot, playerIn.field_71071_by.func_70445_o());
            }
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, clickedButton, mode, this.playerInventory.field_70458_d);
    }

    public void setInput(ItemStack stack) {
        this.handleSlotClick(this.func_75139_a(0), stack);
    }

    public void setContainer(ItemStack stack) {
        this.handleSlotClick(this.func_75139_a(1), stack);
        this.handleSlotClick(this.func_75139_a(2), stack);
        this.handleSlotClick(this.func_75139_a(3), stack);
    }

    private ItemStack handleSlotClick(Slot slot, ItemStack stack) {
        if (stack.func_190916_E() > 0) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(1);
            slot.func_75215_d(copy);
        } else if (slot.func_75211_c().func_190916_E() > 0) {
            slot.func_75215_d(ItemStack.field_190927_a);
        }
        return slot.func_75211_c().func_77946_l();
    }

    public boolean func_75145_c(@NotNull PlayerEntity playerIn) {
        return true;
    }

    @NotNull
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            if (index < 3) {
                this.setContainer(ItemStack.field_190927_a);
                return ItemStack.field_190927_a;
            }
            if (index == 3) {
                this.setInput(ItemStack.field_190927_a);
                return ItemStack.field_190927_a;
            }
            if (BrewingRecipeRegistry.isValidIngredient((ItemStack)stack)) {
                this.setInput(stack);
                return ItemStack.field_190927_a;
            }
            if (BrewingRecipeRegistry.isValidInput((ItemStack)stack) && stack.func_190916_E() == 1) {
                this.setContainer(stack);
                return ItemStack.field_190927_a;
            }
        }
        return ItemStack.field_190927_a;
    }

    public PlayerEntity getPlayer() {
        return this.playerInventory.field_70458_d;
    }

    public World getWorldObj() {
        return this.playerInventory.field_70458_d.field_70170_p;
    }

    public BlockPos getPos() {
        return this.buildingPos;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    private static class InputItemHandler
    extends SlotItemHandler {
        public InputItemHandler(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public int func_75219_a() {
            return 1;
        }

        @NotNull
        public ItemStack func_75209_a(int par1) {
            return ItemStack.field_190927_a;
        }

        public boolean func_75214_a(@NotNull ItemStack par1ItemStack) {
            return true;
        }

        public boolean func_82869_a(PlayerEntity par1PlayerEntity) {
            return false;
        }
    }
}

