/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.items;

import com.minecolonies.api.util.constant.TagConstants;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class ModTags {
    public static boolean tagsLoaded = false;
    public static final Tags.IOptionalNamedTag<Block> decorationItems = BlockTags.createOptional((ResourceLocation)TagConstants.DECORATION_ITEMS);
    public static final Tags.IOptionalNamedTag<Item> concretePowder = ItemTags.createOptional((ResourceLocation)TagConstants.CONCRETE_POWDER);
    public static final Tags.IOptionalNamedTag<Block> concreteBlock = BlockTags.createOptional((ResourceLocation)TagConstants.CONCRETE_BLOCK);
    public static final Tags.IOptionalNamedTag<Block> pathingBlocks = BlockTags.createOptional((ResourceLocation)TagConstants.PATHING_BLOCKS);
    public static final Tags.IOptionalNamedTag<Block> colonyProtectionException = BlockTags.createOptional((ResourceLocation)TagConstants.COLONYPROTECTIONEXCEPTION);
    public static final Tags.IOptionalNamedTag<Block> indestructible = BlockTags.createOptional((ResourceLocation)TagConstants.INDESTRUCTIBLE);
    public static final Tags.IOptionalNamedTag<Block> oreChanceBlocks = BlockTags.createOptional((ResourceLocation)TagConstants.ORECHANCEBLOCKS);
    public static final Tags.IOptionalNamedTag<Block> validSpawn = BlockTags.createOptional((ResourceLocation)TagConstants.VALIDSPAWNBLOCKS);
    public static final Tags.IOptionalNamedTag<Item> fungi = ItemTags.createOptional((ResourceLocation)TagConstants.FUNGI);
    public static final Tags.IOptionalNamedTag<Item> compostables = ItemTags.createOptional((ResourceLocation)TagConstants.COMPOSTABLES);
    public static final Tags.IOptionalNamedTag<Item> compostables_poor = ItemTags.createOptional((ResourceLocation)TagConstants.COMPOSTABLES_POOR);
    public static final Tags.IOptionalNamedTag<Item> compostables_rich = ItemTags.createOptional((ResourceLocation)TagConstants.COMPOSTABLES_RICH);
    public static final Tags.IOptionalNamedTag<Item> meshes = ItemTags.createOptional((ResourceLocation)TagConstants.MESHES);
    public static final Tags.IOptionalNamedTag<Item> floristFlowers = ItemTags.createOptional((ResourceLocation)TagConstants.FLORIST_FLOWERS);
    public static final Tags.IOptionalNamedTag<Item> excludedFood = ItemTags.createOptional((ResourceLocation)TagConstants.EXCLUDED_FOOD);
    public static final Tags.IOptionalNamedTag<EntityType<?>> hostile = EntityTypeTags.createOptional((ResourceLocation)TagConstants.HOSTILE);
    public static final Tags.IOptionalNamedTag<EntityType<?>> mobAttackBlacklist = EntityTypeTags.createOptional((ResourceLocation)TagConstants.MOB_ATTACK_BLACKLIST);
    public static final Map<String, Tags.IOptionalNamedTag<Item>> crafterProduct = new HashMap<String, Tags.IOptionalNamedTag<Item>>();
    public static final Map<String, Tags.IOptionalNamedTag<Item>> crafterProductExclusions = new HashMap<String, Tags.IOptionalNamedTag<Item>>();
    public static final Map<String, Tags.IOptionalNamedTag<Item>> crafterIngredient = new HashMap<String, Tags.IOptionalNamedTag<Item>>();
    public static final Map<String, Tags.IOptionalNamedTag<Item>> crafterIngredientExclusions = new HashMap<String, Tags.IOptionalNamedTag<Item>>();
    private static final String PRODUCT = "_product";
    private static final String PRODUCT_EXCLUDED = "_product_excluded";
    private static final String INGREDIENT = "_ingredient";
    private static final String INGREDIENT_EXCLUDED = "_ingredient_excluded";

    public static void init() {
        ModTags.initCrafterRules(TagConstants.CRAFTING_BAKER);
        ModTags.initCrafterRules(TagConstants.CRAFTING_BLACKSMITH);
        ModTags.initCrafterRules(TagConstants.CRAFTING_COOK);
        ModTags.initCrafterRules(TagConstants.CRAFTING_DYER);
        ModTags.initCrafterRules(TagConstants.CRAFTING_DYER_SMELTING);
        ModTags.initCrafterRules(TagConstants.CRAFTING_FARMER);
        ModTags.initCrafterRules(TagConstants.CRAFTING_FLETCHER);
        ModTags.initCrafterRules(TagConstants.CRAFTING_GLASSBLOWER);
        ModTags.initCrafterRules(TagConstants.CRAFTING_GLASSBLOWER_SMELTING);
        ModTags.initCrafterRules(TagConstants.CRAFTING_MECHANIC);
        ModTags.initCrafterRules("plantation");
        ModTags.initCrafterRules(TagConstants.CRAFTING_SAWMILL);
        ModTags.initCrafterRules(TagConstants.CRAFTING_STONEMASON);
        ModTags.initCrafterRules(TagConstants.CRAFTING_STONE_SMELTERY);
        ModTags.initCrafterRules("reduceable");
    }

    private static void initCrafterRules(@NotNull String crafterName) {
        ResourceLocation products = new ResourceLocation("minecolonies", crafterName.concat(PRODUCT));
        ResourceLocation ingredients = new ResourceLocation("minecolonies", crafterName.concat(INGREDIENT));
        ResourceLocation productsExcluded = new ResourceLocation("minecolonies", crafterName.concat(PRODUCT_EXCLUDED));
        ResourceLocation ingredientsExcluded = new ResourceLocation("minecolonies", crafterName.concat(INGREDIENT_EXCLUDED));
        crafterProduct.put(crafterName, (Tags.IOptionalNamedTag<Item>)ItemTags.createOptional((ResourceLocation)products));
        crafterProductExclusions.put(crafterName, (Tags.IOptionalNamedTag<Item>)ItemTags.createOptional((ResourceLocation)productsExcluded));
        crafterIngredient.put(crafterName, (Tags.IOptionalNamedTag<Item>)ItemTags.createOptional((ResourceLocation)ingredients));
        crafterIngredientExclusions.put(crafterName, (Tags.IOptionalNamedTag<Item>)ItemTags.createOptional((ResourceLocation)ingredientsExcluded));
    }

    private ModTags() {
        throw new IllegalStateException("Can not instantiate an instance of: ModTags. This is a utility class");
    }
}

