/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.loot.ModLootConditions;
import net.minecraft.entity.Entity;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ResearchUnlocked
implements ILootCondition {
    private final ResourceLocation effectId;

    private ResearchUnlocked(@NotNull ResourceLocation effectId) {
        this.effectId = effectId;
    }

    public static ILootCondition.IBuilder effect(@NotNull ResourceLocation effectId) {
        return () -> new ResearchUnlocked(effectId);
    }

    @NotNull
    public LootConditionType func_230419_b_() {
        return ModLootConditions.researchUnlocked;
    }

    public boolean test(@NotNull LootContext lootContext) {
        AbstractEntityCitizen citizen;
        IColony colony;
        Entity entity = (Entity)lootContext.func_216031_c(LootParameters.field_216284_d);
        if (entity instanceof AbstractEntityCitizen && (colony = (citizen = (AbstractEntityCitizen)entity).getCitizenColonyHandler().getColony()) != null) {
            return colony.getResearchManager().getResearchEffects().getEffectStrength(this.effectId) > 0.0;
        }
        return false;
    }

    public static class Serializer
    implements ILootSerializer<ResearchUnlocked> {
        public void serialize(@NotNull JsonObject json, @NotNull ResearchUnlocked condition, @NotNull JsonSerializationContext context) {
            json.addProperty("id", condition.effectId.toString());
        }

        @NotNull
        public ResearchUnlocked deserialize(@NotNull JsonObject json, @NotNull JsonDeserializationContext context) {
            ResourceLocation researchId = new ResourceLocation(JSONUtils.func_151219_a((JsonObject)json, (String)"id", (String)""));
            return new ResearchUnlocked(researchId);
        }
    }
}

