/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.research;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.research.ResearchBranchType;
import com.minecolonies.coremod.generation.DataGeneratorConstants;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractResearchProvider
implements IDataProvider {
    protected final DataGenerator generator;

    public AbstractResearchProvider(DataGenerator generator) {
        this.generator = generator;
    }

    protected abstract Collection<ResearchBranch> getResearchBranchCollection();

    protected abstract Collection<ResearchEffect> getResearchEffectCollection();

    protected abstract Collection<Research> getResearchCollection();

    public void func_200398_a(@NotNull DirectoryCache cache) throws IOException {
        Path savePath;
        Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        JsonObject langJson = new JsonObject();
        for (ResearchBranch branch : this.getResearchBranchCollection()) {
            savePath = this.generator.func_200391_b().resolve("data").resolve(branch.id.func_110624_b()).resolve("researches").resolve(branch.id.func_110623_a() + ".json");
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)branch.json, (Path)savePath);
            if (branch.translatedName != null && !branch.translatedName.isEmpty()) {
                this.addLanguageKeySafe((JsonElement)langJson, "com." + branch.id.func_110624_b() + ".research." + branch.id.func_110623_a().replaceAll("[/]", ".") + ".name", branch.translatedName);
            }
            if (branch.translatedSubtitle == null || branch.translatedSubtitle.isEmpty()) continue;
            this.addLanguageKeySafe((JsonElement)langJson, "com." + branch.id.func_110624_b() + ".research." + branch.id.func_110623_a().replaceAll("[/]", ".") + ".subtitle", branch.translatedSubtitle);
        }
        for (ResearchEffect effect : this.getResearchEffectCollection()) {
            savePath = this.generator.func_200391_b().resolve("data").resolve(effect.id.func_110624_b()).resolve("researches").resolve(effect.id.func_110623_a() + ".json");
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)effect.json, (Path)savePath);
            if (effect.translatedName != null && !effect.translatedName.isEmpty()) {
                this.addLanguageKeySafe((JsonElement)langJson, "com." + effect.id.func_110624_b() + ".research." + effect.id.func_110623_a().replaceAll("[/]", ".") + ".description", effect.translatedName);
            }
            if (effect.translatedSubtitle == null || effect.translatedSubtitle.isEmpty()) continue;
            this.addLanguageKeySafe((JsonElement)langJson, "com." + effect.id.func_110624_b() + ".research." + effect.id.func_110623_a().replaceAll("[/]", ".") + ".subtitle", effect.translatedSubtitle);
        }
        for (Research research : this.getResearchCollection()) {
            savePath = this.generator.func_200391_b().resolve("data").resolve(research.id.func_110624_b()).resolve("researches").resolve(research.id.func_110623_a() + ".json");
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)research.json, (Path)savePath);
            if (research.translatedName != null && !research.translatedName.isEmpty()) {
                this.addLanguageKeySafe((JsonElement)langJson, "com." + research.id.func_110624_b() + ".research." + research.id.func_110623_a().replaceAll("[/]", ".") + ".name", research.translatedName);
            }
            if (research.translatedSubtitle == null || research.translatedSubtitle.isEmpty()) continue;
            this.addLanguageKeySafe((JsonElement)langJson, "com." + research.id.func_110624_b() + ".research." + research.id.func_110623_a().replaceAll("[/]", ".") + ".subtitle", research.translatedSubtitle);
        }
        IDataProvider.func_218426_a((Gson)DataGeneratorConstants.GSON, (DirectoryCache)cache, (JsonElement)langJson, (Path)this.generator.func_200391_b().resolve("assets/minecolonies/lang/default.json"));
    }

    private void addLanguageKeySafe(JsonElement langJson, String key, String property) {
        if (langJson.getAsJsonObject().has(key)) {
            langJson.getAsJsonObject().remove(key);
        }
        langJson.getAsJsonObject().addProperty(key, property);
    }

    @NotNull
    public String func_200397_b() {
        return "Research Data Provider";
    }

    protected static class ResearchBranch {
        public final JsonObject json = new JsonObject();
        public final ResourceLocation id;
        public String translatedName;
        public String translatedSubtitle;

        public ResearchBranch(ResourceLocation id) {
            this.id = id;
        }

        public ResearchBranch setBranchName(String branchName) {
            this.json.addProperty("branch-name", branchName);
            return this;
        }

        public ResearchBranch setTranslatedBranchName(String translatedBranchName) {
            this.translatedName = translatedBranchName;
            this.json.addProperty("branch-name", "com." + this.id.func_110624_b() + ".research." + this.id.func_110623_a().replaceAll("[ /]", ".") + ".name");
            return this;
        }

        public ResearchBranch setSubtitle(String subtitle) {
            this.json.addProperty("subtitle", subtitle);
            return this;
        }

        public ResearchBranch setTranslatedSubtitle(String translatedSubtitle) {
            this.translatedSubtitle = translatedSubtitle;
            this.json.addProperty("subtitle", "com." + this.id.func_110624_b() + ".research." + this.id.func_110623_a().replaceAll("[ /]", ".") + ".subtitle");
            return this;
        }

        public ResearchBranch setBranchTimeMultiplier(double branchTimeMultiplier) {
            this.json.addProperty("base-time", (Number)branchTimeMultiplier);
            return this;
        }

        public ResearchBranch setBranchType(ResearchBranchType type) {
            this.json.addProperty("branch-type", type.tag);
            return this;
        }

        public ResearchBranch setBranchSortOrder(int sortOrder) {
            this.json.addProperty("sortOrder", (Number)sortOrder);
            return this;
        }

        public ResearchBranch setHidden(boolean hidden) {
            this.json.addProperty("hidden", Boolean.valueOf(hidden));
            return this;
        }

        public ResearchBranch setRemove() {
            this.json.addProperty("base-time", (Number)1.0);
            this.json.addProperty("remove", Boolean.valueOf(true));
            return this;
        }

        public ResearchBranch setRemove(ResourceLocation branchId) {
            this.json.addProperty("base-time", (Number)1.0);
            this.json.addProperty("remove", branchId.toString());
            return this;
        }

        public ResearchBranch setRemove(Collection<ResourceLocation> branchIds) {
            this.json.addProperty("base-time", (Number)1.0);
            JsonArray removes = new JsonArray();
            for (ResourceLocation rem : branchIds) {
                removes.add(rem.toString());
            }
            this.json.add("remove", (JsonElement)removes);
            return this;
        }
    }

    protected static class ResearchEffect {
        public final JsonObject json = new JsonObject();
        public final ResourceLocation id;
        public String translatedName;
        public String translatedSubtitle;

        public ResearchEffect(ResourceLocation id) {
            this.id = id;
            this.json.addProperty("effect", Boolean.valueOf(true));
        }

        public ResearchEffect(AbstractBlockHut<?> buildingBlock) {
            this.id = new ResourceLocation(buildingBlock.getRegistryName().func_110624_b(), "effects/" + buildingBlock.getRegistryName().func_110623_a());
            this.json.addProperty("effect", Boolean.valueOf(true));
        }

        public ResearchEffect(ResourceLocation id, String type) {
            this.id = id;
            this.json.addProperty("effect", Boolean.valueOf(true));
            this.json.addProperty("effectType", type);
        }

        public ResearchEffect setLevels(double[] strengths) {
            JsonArray child = new JsonArray();
            for (double str : strengths) {
                child.add((Number)str);
            }
            this.json.add("levels", (JsonElement)child);
            return this;
        }

        public ResearchEffect setName(String name) {
            this.json.addProperty("name", name);
            return this;
        }

        public ResearchEffect setTranslatedName(String name) {
            this.translatedName = name;
            return this;
        }

        public ResearchEffect setSubtitle(String subtitle) {
            this.json.addProperty("subtitle", subtitle);
            return this;
        }

        public ResearchEffect setTranslatedSubtitle(String subtitle) {
            this.translatedSubtitle = subtitle;
            this.json.addProperty("subtitle", "com." + this.id.func_110624_b() + ".research." + this.id.func_110623_a().replaceAll("[/]", ".") + ".subtitle");
            return this;
        }
    }

    protected static class Research {
        public final JsonObject json = new JsonObject();
        public final ResourceLocation id;
        public int researchLevel;
        public String translatedName;
        public String translatedSubtitle;

        public Research(ResourceLocation id, ResourceLocation branch) {
            this.id = id;
            this.researchLevel = 1;
            this.json.addProperty("branch", branch.toString());
            this.json.addProperty("researchLevel", (Number)1);
        }

        public Research setParentResearch(Research parent) {
            this.json.addProperty("parentResearch", parent.id.toString());
            this.json.remove("researchLevel");
            this.researchLevel = parent.researchLevel + 1;
            this.json.addProperty("researchLevel", (Number)this.researchLevel);
            return this;
        }

        public Research setName(String name) {
            this.json.addProperty("name", name);
            return this;
        }

        public Research setTranslatedName(String translatedName) {
            this.translatedName = translatedName;
            return this;
        }

        public Research setSubtitle(String subtitle) {
            this.json.addProperty("subtitle", subtitle);
            return this;
        }

        public Research setTranslatedSubtitle(String translatedSubtitle) {
            this.translatedSubtitle = translatedSubtitle;
            this.json.addProperty("subtitle", "com." + this.id.func_110624_b() + ".research." + this.id.func_110623_a().replaceAll("[ /]", ".") + ".subtitle");
            return this;
        }

        public Research setSortOrder(int sortNum) {
            this.json.addProperty("sortOrder", (Number)sortNum);
            return this;
        }

        public Research setOnlyChild() {
            this.json.addProperty("exclusiveChildResearch", Boolean.valueOf(true));
            return this;
        }

        public Research setNoReset() {
            this.json.addProperty("no-reset", Boolean.valueOf(true));
            return this;
        }

        public Research setAutostart() {
            this.json.addProperty("autostart", Boolean.valueOf(true));
            return this;
        }

        public Research setInstant() {
            this.json.addProperty("instant", Boolean.valueOf(true));
            return this;
        }

        public Research setHidden() {
            this.json.addProperty("hidden", Boolean.valueOf(true));
            return this;
        }

        public Research setIcon(ItemStack item) {
            if (this.json.has("icon")) {
                this.json.remove("icon");
            }
            this.json.addProperty("icon", item.func_77973_b().getRegistryName().toString() + ":" + item.func_190916_E());
            return this;
        }

        public Research setIcon(Item item) {
            if (this.json.has("icon")) {
                this.json.remove("icon");
            }
            this.json.addProperty("icon", item.getRegistryName().toString());
            return this;
        }

        public Research setIcon(Item item, int count) {
            if (this.json.has("icon")) {
                this.json.remove("icon");
            }
            this.json.addProperty("icon", item.getRegistryName().toString() + ":" + count);
            return this;
        }

        public Research setIcon(ResourceLocation texture) {
            this.json.addProperty("icon", texture.toString());
            return this;
        }

        private JsonObject makeSafeBuildingProperty(String propertyType, String buildingName, int level) {
            JsonObject req = new JsonObject();
            req.addProperty(propertyType, buildingName);
            req.addProperty("level", (Number)level);
            return req;
        }

        public Research addBuildingRequirement(String buildingName, int level) {
            JsonArray reqArray;
            if (this.json.has("requirements") && this.json.get("requirements").isJsonArray()) {
                reqArray = this.json.getAsJsonArray("requirements");
                this.json.remove("requirements");
            } else {
                reqArray = new JsonArray();
            }
            reqArray.add((JsonElement)this.makeSafeBuildingProperty("building", buildingName, level));
            this.json.add("requirements", (JsonElement)reqArray);
            return this;
        }

        public Research addMandatoryBuildingRequirement(String buildingName, int level) {
            JsonArray reqArray;
            if (this.json.has("requirements") && this.json.get("requirements").isJsonArray()) {
                reqArray = this.json.getAsJsonArray("requirements");
                this.json.remove("requirements");
            } else {
                reqArray = new JsonArray();
            }
            reqArray.add((JsonElement)this.makeSafeBuildingProperty("mandatory-building", buildingName, level));
            this.json.add("requirements", (JsonElement)reqArray);
            return this;
        }

        public Research addAlternateBuildingRequirement(String buildingName, int level) {
            JsonArray reqArray;
            if (this.json.has("requirements") && this.json.get("requirements").isJsonArray()) {
                reqArray = this.json.getAsJsonArray("requirements");
                this.json.remove("requirements");
            } else {
                reqArray = new JsonArray();
            }
            reqArray.add((JsonElement)this.makeSafeBuildingProperty("alternate-building", buildingName, level));
            this.json.add("requirements", (JsonElement)reqArray);
            return this;
        }

        public Research addResearchRequirement(ResourceLocation researchReq) {
            JsonArray reqArray;
            if (this.json.has("requirements") && this.json.get("requirements").isJsonArray()) {
                reqArray = this.json.getAsJsonArray("requirements");
                this.json.remove("requirements");
            } else {
                reqArray = new JsonArray();
            }
            JsonObject req = new JsonObject();
            req.addProperty("research", researchReq.toString());
            reqArray.add((JsonElement)req);
            this.json.add("requirements", (JsonElement)reqArray);
            return this;
        }

        public Research addResearchRequirement(ResourceLocation researchReq, String name) {
            JsonArray reqArray;
            if (this.json.has("requirements") && this.json.get("requirements").isJsonArray()) {
                reqArray = this.json.getAsJsonArray("requirements");
                this.json.remove("requirements");
            } else {
                reqArray = new JsonArray();
            }
            JsonObject req = new JsonObject();
            req.addProperty("research", researchReq.toString());
            req.addProperty("name", name);
            reqArray.add((JsonElement)req);
            this.json.add("requirements", (JsonElement)reqArray);
            return this;
        }

        public Research addItemCost(ItemStack item) {
            JsonArray reqArray;
            if (this.json.has("requirements") && this.json.get("requirements").isJsonArray()) {
                reqArray = this.json.getAsJsonArray("requirements");
                this.json.remove("requirements");
            } else {
                reqArray = new JsonArray();
            }
            JsonObject req = new JsonObject();
            req.addProperty("item", item.func_77973_b().getRegistryName().toString());
            req.addProperty("quantity", (Number)item.func_190916_E());
            reqArray.add((JsonElement)req);
            this.json.add("requirements", (JsonElement)reqArray);
            return this;
        }

        public Research addItemCost(Item item, int count) {
            JsonArray reqArray;
            if (this.json.has("requirements") && this.json.get("requirements").isJsonArray()) {
                reqArray = this.json.getAsJsonArray("requirements");
                this.json.remove("requirements");
            } else {
                reqArray = new JsonArray();
            }
            JsonObject req = new JsonObject();
            req.addProperty("item", item.getRegistryName().toString());
            req.addProperty("quantity", (Number)count);
            reqArray.add((JsonElement)req);
            this.json.add("requirements", (JsonElement)reqArray);
            return this;
        }

        public Research addEffect(ResourceLocation effect, int level) {
            JsonArray effects;
            if (this.json.has("effects") && this.json.get("effects").isJsonArray()) {
                effects = this.json.getAsJsonArray("effects");
                this.json.remove("effects");
            } else {
                effects = new JsonArray();
            }
            JsonObject eff = new JsonObject();
            eff.addProperty(effect.toString(), (Number)level);
            effects.add((JsonElement)eff);
            this.json.add("effects", (JsonElement)effects);
            return this;
        }

        public Research addEffect(AbstractBlockHut<?> buildingBlock, int level) {
            JsonArray effects;
            if (this.json.has("effects") && this.json.get("effects").isJsonArray()) {
                effects = this.json.getAsJsonArray("effects");
                this.json.remove("effects");
            } else {
                effects = new JsonArray();
            }
            JsonObject eff = new JsonObject();
            eff.addProperty(buildingBlock.getRegistryName().func_110624_b() + ":effects/" + buildingBlock.getRegistryName().func_110623_a(), (Number)level);
            effects.add((JsonElement)eff);
            this.json.add("effects", (JsonElement)effects);
            return this;
        }

        public Research setRemove() {
            this.json.addProperty("remove", Boolean.valueOf(true));
            return this;
        }

        public Research setRemove(ResourceLocation researchId) {
            this.json.addProperty("remove", researchId.toString());
            return this;
        }

        public Research setRemove(Collection<ResourceLocation> researchIds) {
            JsonArray removes = new JsonArray();
            for (ResourceLocation rem : researchIds) {
                removes.add(rem.toString());
            }
            this.json.add("remove", (JsonElement)removes);
            return this;
        }

        public Research addToList(Collection<Research> list) {
            list.add(this);
            return this;
        }
    }
}

