/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.tileentities;

import com.minecolonies.api.blocks.AbstractBlockMinecoloniesRack;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTileEntityRack
extends TileEntity
implements INamedContainerProvider {
    protected boolean single = true;
    protected BlockPos relativeNeighbor = null;
    protected boolean main = false;
    protected boolean inWarehouse = false;
    protected BlockPos buildingPos = BlockPos.field_177992_a;
    protected ItemStackHandler inventory;

    public AbstractTileEntityRack(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.inventory = this.createInventory(27);
    }

    public AbstractTileEntityRack(TileEntityType<?> tileEntityTypeIn, int size) {
        super(tileEntityTypeIn);
        this.inventory = this.createInventory(size);
    }

    public abstract ItemStackHandler createInventory(int var1);

    public void updateWarehouseIfAvailable(ItemStack stack) {
        if (!(ItemStackUtils.isEmpty(stack).booleanValue() || this.field_145850_b == null || this.field_145850_b.field_72995_K || !this.inWarehouse && this.buildingPos.equals((Object)BlockPos.field_177992_a) || !IColonyManager.getInstance().isCoordinateInAnyColony(this.field_145850_b, this.field_174879_c))) {
            IColony colony = IColonyManager.getInstance().getClosestColony(this.field_145850_b, this.field_174879_c);
            if (colony == null) {
                return;
            }
            if (this.inWarehouse) {
                colony.getRequestManager().onColonyUpdate(request -> request.getRequest() instanceof IDeliverable && ((IDeliverable)request.getRequest()).matches(stack));
            } else {
                IBuilding building = colony.getBuildingManager().getBuilding(this.buildingPos);
                if (building != null) {
                    building.overruleNextOpenRequestWithStack(stack);
                }
            }
        }
    }

    public abstract void setInWarehouse(Boolean var1);

    public abstract int getFreeSlots();

    public abstract boolean hasItemStack(ItemStack var1, int var2, boolean var3);

    public abstract int getCount(ItemStack var1, boolean var2, boolean var3);

    public abstract int getCount(ItemStorage var1);

    public abstract boolean hasItemStack(@NotNull Predicate<ItemStack> var1);

    public abstract boolean hasSimilarStack(@NotNull ItemStack var1);

    public abstract void upgradeRackSize();

    public void setBuildingPos(BlockPos pos) {
        if (!(this.field_145850_b == null || this.buildingPos != null && this.buildingPos.equals((Object)pos))) {
            this.func_70296_d();
        }
        this.buildingPos = pos;
    }

    public abstract int getUpgradeSize();

    public abstract int getItemCount(Predicate<ItemStack> var1);

    public abstract void updateItemStorage();

    protected abstract void updateBlockState();

    public abstract AbstractTileEntityRack getOtherChest();

    public abstract boolean isEmpty();

    public void setMain(boolean main) {
        this.main = main;
        this.func_70296_d();
    }

    public void neighborChanged(BlockPos newNeighbor) {
        TileEntity entity = this.field_145850_b.func_175625_s(newNeighbor);
        if (this.relativeNeighbor == null && this.field_145850_b.func_180495_p(newNeighbor).func_177230_c() instanceof AbstractBlockMinecoloniesRack && (!(entity instanceof AbstractTileEntityRack) || ((AbstractTileEntityRack)entity).getOtherChest() == null)) {
            if (!this.setNeighbor(newNeighbor)) {
                return;
            }
            this.setSingle(false);
            if (entity instanceof AbstractTileEntityRack) {
                if (!((AbstractTileEntityRack)entity).isMain()) {
                    this.main = true;
                    ((AbstractTileEntityRack)entity).setMain(false);
                }
                ((AbstractTileEntityRack)entity).setNeighbor(this.func_174877_v());
                entity.func_70296_d();
            }
            this.updateItemStorage();
            this.func_70296_d();
            this.updateBlockState();
        } else if (this.relativeNeighbor != null && this.field_174879_c.func_177973_b((Vector3i)this.relativeNeighbor).equals((Object)newNeighbor) && this.field_145850_b.func_180495_p(newNeighbor).func_177230_c() != ModBlocks.blockRack) {
            this.relativeNeighbor = null;
            this.setSingle(true);
            this.main = false;
            this.updateItemStorage();
            this.updateBlockState();
        }
    }

    public void setSingle(boolean single) {
        this.single = single;
    }

    public boolean isMain() {
        return this.main;
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public abstract BlockPos getNeighbor();

    public abstract boolean setNeighbor(BlockPos var1);

    public class RackInventory
    extends ItemStackHandler {
        public RackInventory(int defaultSize) {
            super(defaultSize);
        }

        protected void onContentsChanged(int slot) {
            AbstractTileEntityRack.this.updateItemStorage();
            super.onContentsChanged(slot);
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.validateSlotIndex(slot);
            boolean changed = !ItemStack.func_77989_b((ItemStack)stack, (ItemStack)((ItemStack)this.stacks.get(slot)));
            this.stacks.set(slot, (Object)stack);
            if (changed) {
                this.onContentsChanged(slot);
            }
            AbstractTileEntityRack.this.updateWarehouseIfAvailable(stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            ItemStack result = super.insertItem(slot, stack, simulate);
            if ((result.func_190926_b() || result.func_190916_E() < stack.func_190916_E()) && !simulate) {
                AbstractTileEntityRack.this.updateWarehouseIfAvailable(stack);
            }
            return result;
        }
    }
}

