/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.tileentities;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.inventory.api.CombinedItemHandler;
import com.minecolonies.api.inventory.container.ContainerBuildingInventory;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import java.util.LinkedHashSet;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityColonyBuilding
extends AbstractTileEntityColonyBuilding
implements ITickableTileEntity {
    private static final String TAG_COLONY = "colony";
    private static final String TAG_MIRROR = "mirror";
    private static final String TAG_STYLE = "style";
    private int colonyId = 0;
    private IColony colony;
    private IBuilding building;
    private boolean mirror;
    private String style = "";
    public ResourceLocation registryName;
    private LazyOptional<CombinedItemHandler> combinedInv;

    public TileEntityColonyBuilding() {
        this(MinecoloniesTileEntities.BUILDING);
    }

    public TileEntityColonyBuilding(TileEntityType<? extends AbstractTileEntityColonyBuilding> type) {
        super(type);
    }

    @Override
    public int getColonyId() {
        return this.colonyId;
    }

    @Override
    public IColony getColony() {
        if (this.colony == null) {
            this.updateColonyReferences();
        }
        return this.colony;
    }

    private void updateColonyReferences() {
        if (this.colony == null && this.func_145831_w() != null) {
            this.colony = this.colonyId == 0 ? IColonyManager.getInstance().getColonyByPosFromWorld(this.func_145831_w(), this.func_174877_v()) : IColonyManager.getInstance().getColonyByWorld(this.colonyId, this.func_145831_w());
            if (this.colony != null || !this.func_145831_w().field_72995_K) {
                // empty if block
            }
        }
        if (this.building == null && this.colony != null) {
            this.building = this.colony.getBuildingManager().getBuilding(this.getPosition());
            if (!(this.building == null || this.func_145831_w() != null && this.func_145831_w().field_72995_K)) {
                this.building.setTileEntity(this);
            }
        }
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    @Override
    @Nullable
    public BlockPos getPositionOfChestWithItemStack(@NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        Predicate<ItemStack> notEmptyPredicate = itemStackSelectionPredicate.and(ItemStackUtils.NOT_EMPTY_PREDICATE);
        @Nullable IBuilding theBuilding = this.getBuilding();
        if (theBuilding != null) {
            for (BlockPos pos : theBuilding.getContainers()) {
                TileEntity entity;
                if (!WorldUtil.isBlockLoaded((IWorld)this.field_145850_b, pos) || !((entity = this.func_145831_w().func_175625_s(pos)) instanceof AbstractTileEntityRack ? ((AbstractTileEntityRack)entity).hasItemStack(notEmptyPredicate) : TileEntityColonyBuilding.isInTileEntity((ICapabilityProvider)entity, notEmptyPredicate))) continue;
                return pos;
            }
        }
        return null;
    }

    @Override
    public void setColony(IColony c) {
        this.colony = c;
        this.colonyId = c.getID();
        this.func_70296_d();
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        if (this.building != null) {
            this.building.markDirty();
        }
    }

    @Override
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT compound = new CompoundNBT();
        this.func_189515_b(compound);
        return new SUpdateTileEntityPacket(this.getPosition(), 0, compound);
    }

    @Override
    @NotNull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Override
    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        CompoundNBT compound = packet.func_148857_g();
        this.colonyId = compound.func_74762_e(TAG_COLONY);
        super.onDataPacket(net, packet);
    }

    public void onLoad() {
        if (this.building != null) {
            this.building.setTileEntity(null);
        }
    }

    @Override
    public IBuilding getBuilding() {
        if (this.building == null) {
            this.updateColonyReferences();
        }
        return this.building;
    }

    @Override
    public void setBuilding(IBuilding b) {
        this.building = b;
    }

    @Override
    @NotNull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a());
    }

    @Override
    public IBuildingView getBuildingView() {
        IColonyView c = IColonyManager.getInstance().getColonyView(this.colonyId, (RegistryKey<World>)this.field_145850_b.func_234923_W_());
        return c == null ? null : c.getBuilding(this.getPosition());
    }

    @Override
    public void func_230337_a_(BlockState state, @NotNull CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_150296_c().contains(TAG_COLONY)) {
            this.colonyId = compound.func_74762_e(TAG_COLONY);
        }
        this.mirror = compound.func_74767_n(TAG_MIRROR);
        this.style = compound.func_74779_i(TAG_STYLE);
        this.registryName = new ResourceLocation(compound.func_74779_i("type"));
        this.buildingPos = this.field_174879_c;
        this.single = true;
    }

    @Override
    @NotNull
    public CompoundNBT func_189515_b(@NotNull CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a(TAG_COLONY, this.colonyId);
        compound.func_74757_a(TAG_MIRROR, this.mirror);
        compound.func_74778_a(TAG_STYLE, this.style);
        compound.func_74778_a("type", this.registryName.toString());
        return compound;
    }

    public void func_73660_a() {
        IColony tempColony;
        if (this.combinedInv != null) {
            this.combinedInv.invalidate();
            this.combinedInv = null;
        }
        if (!this.func_145831_w().field_72995_K && this.colonyId == 0 && (tempColony = IColonyManager.getInstance().getColonyByPosFromWorld(this.func_145831_w(), this.getPosition())) != null) {
            this.colonyId = tempColony.getID();
        }
        if (!this.func_145831_w().field_72995_K && this.colonyId != 0 && this.colony == null) {
            this.updateColonyReferences();
        }
    }

    public boolean isUsableByPlayer(@NotNull PlayerEntity player) {
        return this.hasAccessPermission(player);
    }

    @Override
    public boolean hasAccessPermission(PlayerEntity player) {
        return this.building == null || this.building.getColony().getPermissions().hasPermission(player, Action.ACCESS_HUTS);
    }

    @Override
    public void setMirror(boolean mirror) {
        this.mirror = mirror;
    }

    @Override
    public boolean isMirrored() {
        return this.mirror;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(String style) {
        this.style = style;
    }

    @Override
    public ResourceLocation getBuildingName() {
        return this.registryName;
    }

    @Override
    public boolean isMain() {
        return true;
    }

    @Override
    public void updateBlockState() {
    }

    @Override
    public void setSingle(boolean single) {
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        if (!this.field_145846_f && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.getBuilding() != null) {
            if (this.combinedInv == null) {
                LinkedHashSet<IItemHandlerModifiable> handlers = new LinkedHashSet<IItemHandlerModifiable>();
                World world = this.colony.getWorld();
                if (world != null) {
                    for (BlockPos pos : this.building.getContainers()) {
                        TileEntity te;
                        if (!WorldUtil.isBlockLoaded((IWorld)world, pos) || pos.equals((Object)this.field_174879_c) || (te = world.func_175625_s(pos)) == null) continue;
                        if (te instanceof AbstractTileEntityRack) {
                            handlers.add(((AbstractTileEntityRack)te).getInventory());
                            ((AbstractTileEntityRack)te).setBuildingPos(this.func_174877_v());
                            continue;
                        }
                        this.building.removeContainerPosition(pos);
                    }
                }
                handlers.add(this.getInventory());
                this.combinedInv = LazyOptional.of(() -> new CombinedItemHandler(this.building.getSchematicName(), handlers.toArray(new IItemHandlerModifiable[0])));
            }
            return this.combinedInv;
        }
        return super.getCapability(capability, side);
    }

    @Override
    @Nullable
    public Container createMenu(int id, @NotNull PlayerInventory inv, @NotNull PlayerEntity player) {
        return new ContainerBuildingInventory(id, inv, this.colonyId, this.func_174877_v());
    }
}

