/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.tileentities;

import com.minecolonies.api.blocks.AbstractBlockMinecoloniesGrave;
import com.minecolonies.api.blocks.types.GraveType;
import com.minecolonies.api.colony.GraveData;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.inventory.container.ContainerGrave;
import com.minecolonies.api.tileentities.AbstractTileEntityGrave;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class TileEntityGrave
extends AbstractTileEntityGrave {
    private final Map<ItemStorage, Integer> content = new HashMap<ItemStorage, Integer>();
    private static final String TAG_GRAVE_DATA = "gravedata";

    public TileEntityGrave(TileEntityType<? extends TileEntityGrave> type) {
        super((TileEntityType<? extends AbstractTileEntityGrave>)type);
    }

    public TileEntityGrave() {
        super((TileEntityType<? extends AbstractTileEntityGrave>)MinecoloniesTileEntities.GRAVE);
    }

    @Override
    public Map<ItemStorage, Integer> getAllContent() {
        return this.content;
    }

    @Override
    public void updateItemStorage() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            boolean empty = this.content.isEmpty();
            this.updateContent();
            if (empty && !this.content.isEmpty() || !empty && this.content.isEmpty()) {
                this.updateBlockState();
            }
            this.func_70296_d();
        }
    }

    private void updateContent() {
        this.content.clear();
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
            ItemStorage storage = new ItemStorage(stack.func_77946_l());
            int amount = ItemStackUtils.getSize(stack);
            if (this.content.containsKey(storage)) {
                amount += this.content.remove(storage).intValue();
            }
            this.content.put(storage, amount);
        }
    }

    @Override
    public void updateBlockState() {
        if (this.field_145850_b != null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof AbstractBlockMinecoloniesGrave) {
            BlockState state = (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a(AbstractBlockMinecoloniesGrave.VARIANT, (Comparable)((Object)(this.decayed ? GraveType.DECAYED : GraveType.DEFAULT)));
            if (!this.field_145850_b.func_180495_p(this.field_174879_c).equals(state)) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state);
            }
        }
    }

    @Override
    public ItemStackHandler createInventory(int slots) {
        return new AbstractTileEntityRack.RackInventory(slots);
    }

    @Override
    public boolean isEmpty() {
        this.updateContent();
        return this.content.isEmpty();
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.decay_timer = compound.func_74764_b("decaytimer") ? compound.func_74762_e("decaytimer") : 6000;
        boolean bl = this.decayed = compound.func_74764_b("decayed") ? compound.func_74767_n("decayed") : false;
        if (compound.func_150296_c().contains(TAG_GRAVE_DATA)) {
            this.graveData = new GraveData();
            this.graveData.read(compound.func_74775_l(TAG_GRAVE_DATA));
        } else {
            this.graveData = null;
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("decaytimer", this.decay_timer);
        compound.func_74757_a("decayed", this.decayed);
        if (this.graveData != null) {
            compound.func_218657_a(TAG_GRAVE_DATA, (INBT)this.graveData.write());
        }
        return compound;
    }

    @Override
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT compound = new CompoundNBT();
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189515_b(compound));
    }

    @Override
    @NotNull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    @Override
    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    @Override
    public void func_70296_d() {
        if (this.field_145850_b != null) {
            WorldUtil.markChunkDirty(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    @Nullable
    public Container createMenu(int id, @NotNull PlayerInventory inv, @NotNull PlayerEntity player) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.func_179255_a(this.func_174877_v());
        return new ContainerGrave(id, inv, buffer);
    }

    @Override
    @NotNull
    public ITextComponent func_145748_c_() {
        return new StringTextComponent("Grave");
    }

    public boolean onColonyTick(double delay) {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && this.decay_timer != -1) {
            this.decay_timer = (int)((double)this.decay_timer - delay);
            if (this.decay_timer <= 0) {
                if (!this.decayed) {
                    this.decayed = true;
                    this.decay_timer = 6000;
                    this.updateBlockState();
                } else {
                    InventoryUtils.dropItemHandler((IItemHandler)this.inventory, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
                    this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
                    return false;
                }
            }
        }
        return true;
    }
}

