/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneBuilders;
import com.ldtteam.blockout.controls.ButtonImage;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.api.colony.buildings.modules.IModuleWindow;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import java.util.Locale;
import java.util.Random;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class AbstractModuleWindow
extends AbstractWindowSkeleton
implements IModuleWindow {
    protected final IBuildingView buildingView;

    public AbstractModuleWindow(IBuildingView building, String res) {
        super(res);
        this.buildingView = building;
        Random random = new Random(building.getID().hashCode());
        int offset = 0;
        if (building.getAllModuleViews().size() > 0) {
            ButtonImage image = new ButtonImage();
            image.setImage("minecolonies:textures/gui/modules/tab_side" + (random.nextInt(3) + 1) + ".png");
            image.setPosition(-20, 10 + offset);
            image.setSize(32, 26);
            image.setHandler(button -> building.getWindow().open());
            ButtonImage iconImage = new ButtonImage();
            iconImage.setImage("minecolonies:textures/gui/modules/main.png");
            iconImage.setID("main");
            iconImage.setPosition(-15, 13 + offset);
            iconImage.setSize(20, 20);
            iconImage.setHandler(button -> building.getWindow().open());
            offset += image.getHeight() + 2;
            this.addChild((Pane)image);
            this.addChild((Pane)iconImage);
            PaneBuilders.tooltipBuilder().hoverPane((Pane)iconImage).build().setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.maintab"));
        }
        for (IBuildingModuleView view : building.getAllModuleViews()) {
            if (!view.isPageVisible()) continue;
            ButtonImage image = new ButtonImage();
            image.setImage("minecolonies:textures/gui/modules/tab_side" + (random.nextInt(3) + 1) + ".png");
            image.setPosition(-20, 10 + offset);
            image.setSize(32, 26);
            image.setHandler(button -> view.getWindow().open());
            String icon = view.getIcon();
            ButtonImage iconImage = new ButtonImage();
            iconImage.setImage("minecolonies:textures/gui/modules/" + icon + ".png");
            iconImage.setSize(20, 20);
            iconImage.setID(icon);
            iconImage.setPosition(-15, 13 + offset);
            iconImage.setHandler(button -> view.getWindow().open());
            offset += image.getHeight() + 2;
            this.addChild((Pane)image);
            this.addChild((Pane)iconImage);
            PaneBuilders.tooltipBuilder().hoverPane((Pane)iconImage).build().setText((IFormattableTextComponent)new TranslationTextComponent(view.getDesc().toLowerCase(Locale.US)));
        }
    }
}

