/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.citizen;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.ScrollingList;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.coremod.client.gui.citizen.AbstractWindowCitizen;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class FamilyWindowCitizen
extends AbstractWindowCitizen {
    private final ICitizenDataView citizen;
    protected final ScrollingList siblingList;
    protected final ScrollingList childrenList;

    public FamilyWindowCitizen(ICitizenDataView citizen) {
        super(citizen, "minecolonies:gui/citizen/family.xml");
        this.citizen = citizen;
        this.siblingList = (ScrollingList)this.findPaneOfTypeByID("siblings", ScrollingList.class);
        this.childrenList = (ScrollingList)this.findPaneOfTypeByID("children", ScrollingList.class);
    }

    @Override
    public void onOpened() {
        super.onOpened();
        String firstParent = this.citizen.getParents().getA();
        String secondParent = this.citizen.getParents().getB();
        ((Text)this.findPaneOfTypeByID("parentA", Text.class)).setText((IFormattableTextComponent)(firstParent.isEmpty() ? new TranslationTextComponent("com.minecolonies.coremod.gui.citizen.family.unknown") : new StringTextComponent(firstParent)));
        ((Text)this.findPaneOfTypeByID("parentB", Text.class)).setText((IFormattableTextComponent)(secondParent.isEmpty() ? new TranslationTextComponent("com.minecolonies.coremod.gui.citizen.family.unknown") : new StringTextComponent(secondParent)));
        int partner = this.citizen.getPartner();
        ICitizenDataView partnerView = this.colony.getCitizen(partner);
        Text partnerText = (Text)this.findPaneOfTypeByID("partner", Text.class);
        if (partnerView == null) {
            partnerText.setText((IFormattableTextComponent)new StringTextComponent("-"));
        } else {
            partnerText.setText((IFormattableTextComponent)new StringTextComponent(partnerView.getName()));
        }
        this.childrenList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return FamilyWindowCitizen.this.citizen.getChildren().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText((IFormattableTextComponent)new StringTextComponent(FamilyWindowCitizen.this.colony.getCitizen(FamilyWindowCitizen.this.citizen.getChildren().get(index)).getName()));
            }
        });
        this.siblingList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return FamilyWindowCitizen.this.citizen.getSiblings().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText((IFormattableTextComponent)new StringTextComponent(FamilyWindowCitizen.this.colony.getCitizen(FamilyWindowCitizen.this.citizen.getSiblings().get(index)).getName()));
            }
        });
    }
}

